/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.net;

import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;

public abstract class InetSocketAddressNetServerAttributesGetter<REQUEST>
implements NetServerAttributesGetter<REQUEST> {
    @Nullable
    protected abstract InetSocketAddress getPeerSocketAddress(REQUEST var1);

    @Nullable
    protected abstract InetSocketAddress getHostSocketAddress(REQUEST var1);

    @Override
    @Nullable
    public String sockFamily(REQUEST request) {
        InetSocketAddress address = this.getPeerSocketAddress(request);
        if (address == null) {
            address = this.getHostSocketAddress(request);
        }
        if (address == null) {
            return null;
        }
        InetAddress inetAddress = address.getAddress();
        if (inetAddress instanceof Inet6Address) {
            return "inet6";
        }
        return null;
    }

    @Override
    @Nullable
    public final String sockPeerAddr(REQUEST request) {
        return InetSocketAddressNetServerAttributesGetter.getAddress(this.getPeerSocketAddress(request));
    }

    @Override
    @Nullable
    public final Integer sockPeerPort(REQUEST request) {
        return InetSocketAddressNetServerAttributesGetter.getPort(this.getPeerSocketAddress(request));
    }

    @Override
    @Nullable
    public String sockHostAddr(REQUEST request) {
        return InetSocketAddressNetServerAttributesGetter.getAddress(this.getHostSocketAddress(request));
    }

    @Override
    @Nullable
    public Integer sockHostPort(REQUEST request) {
        return InetSocketAddressNetServerAttributesGetter.getPort(this.getHostSocketAddress(request));
    }

    @Nullable
    private static String getAddress(InetSocketAddress address) {
        if (address == null) {
            return null;
        }
        InetAddress remoteAddress = address.getAddress();
        if (remoteAddress != null) {
            return remoteAddress.getHostAddress();
        }
        return null;
    }

    @Nullable
    private static Integer getPort(InetSocketAddress address) {
        if (address == null) {
            return null;
        }
        return address.getPort();
    }
}

