/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.yoko.rmi.impl.CopyRecursionException;
import org.apache.yoko.rmi.impl.CopyRecursionResolver;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.FieldDescriptor;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.MARSHAL;

class ObjectFieldDescriptor
extends FieldDescriptor {
    ObjectFieldDescriptor(Class owner, Class type, String name, Field f, TypeRepository repository) {
        super(owner, type, name, f, repository);
    }

    @Override
    public void read(ObjectReader reader, Object obj) throws IOException {
        try {
            this.field.set(obj, reader.readAbstractObject());
        }
        catch (IllegalAccessException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    @Override
    public void write(ObjectWriter writer, Object obj) throws IOException {
        try {
            writer.writeObject(this.field.get(obj));
        }
        catch (IllegalAccessException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    void copyState(Object orig, final Object copy, CopyState state) {
        try {
            this.field.set(copy, state.copy(this.field.get(orig)));
        }
        catch (CopyRecursionException e) {
            state.registerRecursion(new CopyRecursionResolver(orig){

                @Override
                public void resolve(Object value) {
                    try {
                        ObjectFieldDescriptor.this.field.set(copy, value);
                    }
                    catch (IllegalAccessException ex) {
                        throw (InternalError)new InternalError(ex.getMessage()).initCause(ex);
                    }
                }
            });
        }
        catch (IllegalAccessException ex) {
            throw (InternalError)new InternalError(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    void readFieldIntoMap(ObjectReader reader, Map map) throws IOException {
        Object value = reader.readAbstractObject();
        map.put(this.java_name, value);
    }

    @Override
    void writeFieldFromMap(ObjectWriter writer, Map map) throws IOException {
        Object value = map.get(this.java_name);
        writer.writeObject(value);
    }
}

