/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils.ras;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class FormattedWriter
extends BufferedWriter {
    private int _indent = 0;
    private String _namespace = "";

    public FormattedWriter(Writer out) {
        super(out);
    }

    public FormattedWriter(Writer out, int sz) {
        super(out, sz);
    }

    public final void comment(String comment) throws IOException {
        this.startComment();
        this.write(comment);
        this.endComment();
    }

    public final void endComment() throws IOException {
        this.write("-->");
    }

    public final void emptyTag(String tag) throws IOException {
        this.write(60);
        this.write(this._namespace + tag);
        this.write("/>");
    }

    public final void endTag(String tag) throws IOException {
        this.write("</");
        this.write(this._namespace + tag);
        this.write(62);
    }

    public final void indent() {
        ++this._indent;
    }

    public final void introducer(String text) throws IOException {
        this.write("<?" + text + "?>");
        this.newLine();
    }

    @Override
    public void newLine() throws IOException {
        this.flush();
        super.newLine();
        for (int i = 0; i < this._indent; ++i) {
            this.write("  ");
        }
    }

    public final void outdent() {
        --this._indent;
    }

    public final void nameSpace(String namespace) {
        this._namespace = namespace == null || namespace.equals("") ? "" : namespace + ":";
    }

    public final String getNameSpace() {
        return this._namespace;
    }

    public final void startComment() throws IOException {
        this.write("<!--");
    }

    public final void startTag(String tag) throws IOException {
        this.write(60);
        this.write(this._namespace + tag);
        this.write(62);
    }

    public final void taggedValue(String tag, long value) throws IOException {
        this.startTag(tag);
        this.write(Long.toString(value));
        this.endTag(tag);
    }

    public final void taggedValue(String tag, Object value) throws IOException {
        this.startTag(tag);
        if (value == null) {
            this.write("null");
        } else {
            this.write(value.toString());
        }
        this.endTag(tag);
    }

    public final void write(Throwable e) throws IOException {
        this.indent();
        this.newLine();
        this.write(e.toString());
        StackTraceElement[] elements = e.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            this.newLine();
            this.write(elements[i].toString());
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            this.newLine();
            this.write(cause.toString());
        }
        this.outdent();
    }
}

