/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import io.opentelemetry.semconv.JvmAttributes;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public final class ExperimentalMemoryPools {
    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        return ExperimentalMemoryPools.registerObservers(openTelemetry, ManagementFactory.getMemoryPoolMXBeans());
    }

    static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, List<MemoryPoolMXBean> poolBeans) {
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        return Collections.singletonList(meter.upDownCounterBuilder("jvm.memory.init").setDescription("Measure of initial memory requested.").setUnit("By").buildWithCallback(ExperimentalMemoryPools.callback(poolBeans)));
    }

    private static Consumer<ObservableLongMeasurement> callback(List<MemoryPoolMXBean> poolBeans) {
        ArrayList<Attributes> attributeSets = new ArrayList<Attributes>(poolBeans.size());
        for (MemoryPoolMXBean pool : poolBeans) {
            attributeSets.add(Attributes.builder().put(JvmAttributes.JVM_MEMORY_POOL_NAME, pool.getName()).put(JvmAttributes.JVM_MEMORY_TYPE, ExperimentalMemoryPools.memoryType(pool.getType())).build());
        }
        return measurement -> {
            for (int i = 0; i < poolBeans.size(); ++i) {
                long value;
                Attributes attributes = (Attributes)attributeSets.get(i);
                MemoryUsage memoryUsage = ((MemoryPoolMXBean)poolBeans.get(i)).getUsage();
                if (memoryUsage == null || (value = memoryUsage.getInit()) == -1L) continue;
                measurement.record(value, attributes);
            }
        };
    }

    private static String memoryType(MemoryType memoryType) {
        switch (memoryType) {
            case HEAP: {
                return "heap";
            }
            case NON_HEAP: {
                return "non_heap";
            }
        }
        return "unknown";
    }

    private ExperimentalMemoryPools() {
    }
}

