/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.EJBPMICollaborator;
import jakarta.ejb.AsyncResult;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class ServerAsyncResult
implements Future<Object> {
    private static final TraceComponent tc = Tr.register(ServerAsyncResult.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private Future<?> ivFuture;
    private Throwable ivException = null;
    private volatile boolean ivCancelled = false;
    private volatile boolean ivWasCancelCalled = false;
    private volatile boolean ivDone = false;
    private final CountDownLatch ivGate = new CountDownLatch(1);
    public final EJBPMICollaborator ivPmiBean;

    public ServerAsyncResult(EJBPMICollaborator pmiBean) {
        this.ivPmiBean = pmiBean;
    }

    protected void done() {
        this.ivDone = true;
        this.ivGate.countDown();
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("cancel - Future object: " + this), (Object[])new Object[]{mayInterruptIfRunning});
        }
        boolean cancelled = false;
        if (!this.ivCancelled) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"attempting to remove from work queue", (Object[])new Object[0]);
            }
            if (cancelled = this.doCancel()) {
                this.ivCancelled = true;
                this.done();
                if (this.ivPmiBean != null) {
                    this.ivPmiBean.asyncMethodCallCanceled();
                    this.ivPmiBean.asyncQueSizeDecrement();
                }
            } else {
                this.ivWasCancelCalled = mayInterruptIfRunning;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancel", (Object)cancelled);
        }
        return cancelled;
    }

    protected abstract boolean doCancel();

    public boolean wasCancelCalled() {
        return this.ivWasCancelCalled;
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("get - Future object: " + this), (Object[])new Object[0]);
        }
        this.await(0L, null);
        Object result = this.getResult();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("get: " + Util.identity((Object)result)));
        }
        return result;
    }

    private Object getResult() throws InterruptedException, ExecutionException {
        if (this.ivCancelled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResult: throwing CancellationException");
            }
            throw new CancellationException();
        }
        if (this.ivException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getResult: " + this.ivException));
            }
            throw new ExecutionException(this.ivException);
        }
        Object resultToReturn = null;
        if (this.ivFuture != null) {
            resultToReturn = this.ivFuture.get();
        }
        return resultToReturn;
    }

    private Object getResult(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.ivCancelled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResult: throwing CancellationException");
            }
            throw new CancellationException();
        }
        if (this.ivException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getResult: " + this.ivException));
            }
            throw new ExecutionException(this.ivException);
        }
        Object resultToReturn = null;
        if (this.ivFuture != null) {
            resultToReturn = this.ivFuture instanceof AsyncResult ? this.ivFuture.get() : this.ivFuture.get(timeout, unit);
        }
        return resultToReturn;
    }

    protected boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (unit == null) {
            this.ivGate.await();
            return true;
        }
        return this.ivGate.await(timeout, unit);
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            String completeTime = "Timeout setting: " + timeout + " " + (Object)((Object)unit);
            Tr.entry((TraceComponent)tc, (String)("get - " + completeTime + " Future object: " + this), (Object[])new Object[0]);
        }
        if (unit == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"get - null unit");
            }
            throw new NullPointerException("unit");
        }
        long startTime = System.nanoTime();
        if (!this.await(timeout, unit)) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"get - asynchronous method timed out, throwing TimeoutException.");
            }
            throw new TimeoutException();
        }
        long remainingTime = timeout - unit.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        Object resultToReturn = this.getResult(remainingTime, unit);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("get: " + Util.identity((Object)resultToReturn)));
        }
        return resultToReturn;
    }

    @Override
    public boolean isCancelled() {
        boolean cancelled = this.ivCancelled;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isCancelled: " + cancelled + " Future object: " + this), (Object[])new Object[0]);
        }
        return cancelled;
    }

    @Override
    public boolean isDone() {
        boolean done = this.ivDone;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isDone: " + done + " Future object: " + this), (Object[])new Object[0]);
        }
        return done;
    }

    void setResult(Future<?> theFuture) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setResult: " + Util.identity(theFuture) + " Future object: " + this), (Object[])new Object[0]);
        }
        this.ivFuture = theFuture;
        this.done();
    }

    void setException(Throwable theException) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setException - Future object: " + this), (Object[])new Object[]{theException});
        }
        this.ivException = theException;
        this.done();
    }
}

