/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.internal;

import io.opentelemetry.internal.shaded.jctools.queues.MessagePassingQueue;
import io.opentelemetry.internal.shaded.jctools.queues.MpscArrayQueue;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Consumer;

public final class JcTools {
    public static <T> Queue<T> newFixedSizeQueue(int capacity) {
        try {
            return new MpscArrayQueue(capacity);
        }
        catch (NoClassDefFoundError e) {
            return new ArrayBlockingQueue(capacity);
        }
    }

    public static long capacity(Queue<?> queue) {
        if (queue instanceof MessagePassingQueue) {
            return ((MessagePassingQueue)((Object)queue)).capacity();
        }
        return (long)((ArrayBlockingQueue)queue).remainingCapacity() + (long)queue.size();
    }

    public static <T> void drain(Queue<T> queue, int limit, Consumer<T> consumer) {
        if (queue instanceof MessagePassingQueue) {
            ((MessagePassingQueue)((Object)queue)).drain(consumer::accept, limit);
        } else {
            JcTools.drainNonJcQueue(queue, limit, consumer);
        }
    }

    private static <T> void drainNonJcQueue(Queue<T> queue, int maxExportBatchSize, Consumer<T> consumer) {
        T item;
        int polledCount = 0;
        while (polledCount++ < maxExportBatchSize && (item = queue.poll()) != null) {
            consumer.accept(item);
        }
    }

    private JcTools() {
    }
}

