/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.ForeignDestinationDefault;
import com.ibm.ws.sib.admin.SIBExceptionBusNotFound;
import com.ibm.ws.sib.admin.SIBExceptionNoLinkExists;
import com.ibm.ws.sib.admin.SIBExceptionObjectNotFound;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.processor.impl.AliasDestinationHandler;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.impl.ForeignBus;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BusHandler
extends AliasDestinationHandler {
    private static final TraceComponent tc = SibTr.register(BusHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ForeignBusDefinition _foreignBusDefinition = null;
    private ForeignDestinationDefault _foreignDestinationDefault = null;

    public BusHandler(ForeignBusDefinition foreignBusDefinition, MessageProcessor messageProcessor, SIMPItemStream parentItemStream, HashMap durableSubscriptionsTable, LinkHandler resolvedDestinationHandler) throws SINotPossibleInCurrentConfigurationException {
        super(null, messageProcessor, parentItemStream, resolvedDestinationHandler, messageProcessor.getMessagingEngineBus());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BusHandler", (Object)new Object[]{foreignBusDefinition, messageProcessor, parentItemStream, durableSubscriptionsTable, resolvedDestinationHandler});
        }
        this._foreignBusDefinition = foreignBusDefinition;
        this._sendAllowedOnTargetForeignBus = foreignBusDefinition.getSendAllowed() ? Boolean.TRUE : Boolean.FALSE;
        try {
            this._foreignDestinationDefault = foreignBusDefinition.getDestinationDefault();
        }
        catch (SIBExceptionObjectNotFound e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BusHandler.BusHandler", (String)"1:177:1.54", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new SINotPossibleInCurrentConfigurationException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BusHandler", (Object)this);
        }
    }

    public void updateDefinition(DestinationDefinition destinationDefinition) {
        throw new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.BusGroup", "1:202:1.54", this.getName()}, null));
    }

    public void updateDefinition(ForeignBusDefinition foreignBusDefinition) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateDefinition", (Object)foreignBusDefinition);
        }
        ForeignDestinationDefault newForeignDefault = null;
        this.updateSendAllowed(this._foreignBusDefinition.getSendAllowed(), foreignBusDefinition.getSendAllowed());
        try {
            VirtualLinkDefinition vld = foreignBusDefinition.getLinkForNextHop();
            this.updateVirtualLinkDefinition(vld);
            this._foreignDestinationDefault = newForeignDefault = foreignBusDefinition.getDestinationDefault();
            this._foreignBusDefinition = foreignBusDefinition;
        }
        catch (SIBExceptionObjectNotFound e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BusHandler.updateDefinition", (String)"1:242:1.54", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (SIBExceptionNoLinkExists e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BusHandler.updateDefinition", (String)"1:254:1.54", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (SIIncorrectCallException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BusHandler.updateDefinition", (String)"1:266:1.54", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (SIBExceptionBusNotFound e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BusHandler.updateDefinition", (String)"1:278:1.54", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateDefinition");
        }
    }

    public void updateSendAllowed(boolean oldSendAllowed, boolean newSendAllowed) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateSendAllowed", (Object)new Object[]{oldSendAllowed, newSendAllowed});
        }
        if (oldSendAllowed && !newSendAllowed) {
            this.setForeignBusSendAllowed(false);
        } else if (!oldSendAllowed && newSendAllowed) {
            this.setForeignBusSendAllowed(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateSendAllowed");
        }
    }

    public void updateVirtualLinkDefinition(VirtualLinkDefinition newVirtualLinkDefinition) throws SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateVirtualLinkDefinition", (Object)new Object[]{newVirtualLinkDefinition});
        }
        LinkHandler lh = (LinkHandler)this._targetDestinationHandler;
        LocalTransaction transaction = this.txManager.createLocalTransaction(true);
        try {
            lh.updateLinkDefinition(newVirtualLinkDefinition, transaction);
            transaction.commit();
        }
        catch (SIResourceException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"updateVirtualLinkDefinition", (Object)((Object)e));
            }
            try {
                transaction.rollback();
            }
            catch (Throwable et) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BusHandler.updateVirtualLinkDefinition", (String)"1:359:1.54", (Object)this);
                SibTr.exception((TraceComponent)tc, (Throwable)et);
            }
            throw e;
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BusHandler.updateVirtualLinkDefinition", (String)"1:373:1.54", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.exit((TraceComponent)tc, (String)"updateVirtualLinkDefinition", (Object)e);
            }
            try {
                transaction.rollback();
            }
            catch (Throwable et) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BusHandler.updateVirtualLinkDefinition", (String)"1:392:1.54", (Object)this);
                SibTr.exception((TraceComponent)tc, (Throwable)et);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateVirtualLinkDefinition");
        }
    }

    @Override
    public boolean isPubSub() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isPubSub");
            SibTr.exit((TraceComponent)tc, (String)"isPubSub", (Object)Boolean.FALSE);
        }
        return false;
    }

    @Override
    public Reliability getDefaultReliability() {
        return this._foreignDestinationDefault.getDefaultReliability();
    }

    @Override
    public Reliability getMaxReliability() {
        return this._foreignDestinationDefault.getMaxReliability();
    }

    @Override
    public int getDefaultPriority() {
        return this._foreignDestinationDefault.getDefaultPriority();
    }

    @Override
    public long getAlterationTime() {
        throw new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.BusGroup", "1:453:1.54", this.getName()}, null));
    }

    @Override
    public String getDescription() {
        return this._foreignBusDefinition.getDescription();
    }

    @Override
    public DestinationType getDestinationType() {
        return DestinationType.UNKNOWN;
    }

    @Override
    public SIDestinationAddress[] getDefaultForwardRoutingPath() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultForwardRoutingPath");
            SibTr.exit((TraceComponent)tc, (String)"getDefaultForwardRoutingPath", null);
        }
        return null;
    }

    @Override
    public boolean isSendAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        boolean sendAllowed = this._sendAllowedOnTargetForeignBus.equals(Boolean.FALSE) ? false : this._foreignDestinationDefault.isSendAllowed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)sendAllowed);
        }
        return sendAllowed;
    }

    @Override
    public boolean isReceiveAllowed() {
        return false;
    }

    public boolean isInQuiesceMode() {
        throw new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.BusGroup", "1:529:1.54", this.getName()}, null));
    }

    @Override
    public boolean isTemporary() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTemporary");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTemporary", (Object)Boolean.FALSE);
        }
        return false;
    }

    @Override
    public boolean isSystem() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSystem");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSystem", (Object)Boolean.FALSE);
        }
        return false;
    }

    @Override
    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled() && this._foreignBusDefinition == null) {
            return "ForeignDestNullName";
        }
        return this._foreignBusDefinition.getName();
    }

    @Override
    public SIBUuid12 getUuid() {
        return this._foreignBusDefinition.getUuid();
    }

    public PtoPMessageItemStream getLocalisation(SIBUuid8 meUuid) {
        throw new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.BusGroup", "1:591:1.54", this.getName()}, null));
    }

    @Override
    public boolean isReconciled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReconciled");
            SibTr.exit((TraceComponent)tc, (String)"isReconciled", (Object)Boolean.TRUE);
        }
        return true;
    }

    public ControlHandler getControlHandler(ProtocolType type, SIBUuid8 sourceCellule) {
        throw new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.BusGroup", "1:651:1.54", this.getName()}, null));
    }

    @Override
    public List getSubscriptionList() {
        throw new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.BusGroup", "1:666:1.54", this.getName()}, null));
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this.controlAdapter = new ForeignBus(this.messageProcessor, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter", (Object)this.controlAdapter);
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public boolean isOverrideOfQOSByProducerAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isOverrideOfQOSByProducerAllowed");
        }
        boolean override = this._foreignDestinationDefault.isOverrideOfQOSByProducerAllowed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isOverrideOfQOSByProducerAllowed", (Object)override);
        }
        return override;
    }

    @Override
    public Object getContextValue(String keyName) {
        Map context;
        Object property;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getContextValue", (Object)keyName);
        }
        if (null == (property = (context = this._foreignDestinationDefault.getDestinationContext()).get(keyName))) {
            property = this.getTarget().getContextValue(keyName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getContextValue", property);
        }
        return property;
    }

    Map getDestinationContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationContext");
        }
        Map context = this._foreignDestinationDefault.getDestinationContext();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationContext", (Object)context);
        }
        return context;
    }

    @Override
    public List getForwardRoutingPath() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForwardRoutingPath");
            SibTr.exit((TraceComponent)tc, (String)"getForwardRoutingPath", null);
        }
        return null;
    }

    @Override
    public JsDestinationAddress getReplyDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReplyDestination");
            SibTr.exit((TraceComponent)tc, (String)"getReplyDestination", null);
        }
        return null;
    }

    @Override
    public JsDestinationAddress getRoutingDestinationAddr(JsDestinationAddress inAddress, boolean fixedMessagePoint) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRoutingDestinationAddr", (Object)new Object[]{this, inAddress, fixedMessagePoint});
        }
        JsDestinationAddress outAddress = inAddress;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRoutingDestinationAddr", (Object)outAddress);
        }
        return outAddress;
    }

    @Override
    public boolean checkDestinationAccess(SecurityContext secContext, OperationType operation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Object[]{secContext, operation});
        }
        boolean allow = false;
        if (this.accessChecker.checkForeignBusAccess(secContext, this.getName(), operation)) {
            allow = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess", (Object)allow);
        }
        return allow;
    }

    @Override
    public boolean isTopicAccessCheckRequired() {
        return false;
    }

    @Override
    public boolean checkDiscriminatorAccess(SecurityContext secContext, OperationType operation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDiscriminatorAccess", (Object)new Object[]{secContext, operation});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDiscriminatorAccess", (Object)true);
        }
        return true;
    }

    @Override
    public boolean isForeignBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isForeignBus");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isForeignBus", (Object)Boolean.TRUE);
        }
        return true;
    }

    @Override
    public String toString() {
        return "BusHandler to [" + this._foreignBusDefinition + "] with dest default [" + this._foreignDestinationDefault + "]";
    }

    @Override
    public boolean isAlias() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAlias");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isAlias", (Object)Boolean.FALSE);
        }
        return false;
    }
}

