/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.TranWrapper;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import jakarta.resource.NotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.transaction.Synchronization;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XATransactionWrapper
implements XAResource,
Synchronization,
TranWrapper {
    private final MCWrapper mcWrapper;
    private XAResource xaResource;
    private boolean enlisted = false;
    private boolean hasRollbackOccured = false;
    private static final TraceComponent tc = Tr.register(XATransactionWrapper.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");

    protected XATransactionWrapper(MCWrapper mcWrapper) {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        this.mcWrapper = mcWrapper;
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected void initialize() throws ResourceException {
        if (this.xaResource == null) {
            try {
                this.xaResource = this.mcWrapper.getManagedConnection().getXAResource();
            }
            catch (ResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.initialize", (String)"149", (Object)this);
                Tr.error((TraceComponent)tc, (String)"FAILED_TO_OBTAIN_XAResource_J2CA0078", (Object[])new Object[]{e, this.mcWrapper.gConfigProps.cfName});
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.initialize", (String)"154", (Object)this);
                String pmiName = null;
                if (this.mcWrapper != null) {
                    pmiName = this.mcWrapper.gConfigProps.cfName;
                }
                Tr.error((TraceComponent)tc, (String)"FAILED_TO_OBTAIN_XAResource_J2CA0078", (Object[])new Object[]{e, pmiName});
                ResourceException re = new ResourceException("initialize: caught Exception");
                re.initCause((Throwable)e);
                throw re;
            }
        }
    }

    public void cleanup() {
        this.enlisted = false;
    }

    public void releaseResources() {
        this.xaResource = null;
    }

    @Override
    public boolean addSync() throws ResourceException {
        UOWCoordinator uowCoord;
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"addSync", (Object[])new Object[0]);
        }
        if ((uowCoord = this.mcWrapper.getUOWCoordinator()) == null) {
            IllegalStateException e = new IllegalStateException("addSync: illegal state exception. uowCoord is null");
            Object[] parms = new Object[]{"addSync", e};
            Tr.error((TraceComponent)tc, (String)"ILLEGAL_STATE_EXCEPTION_J2CA0079", (Object[])parms);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"addSync", (Object)e);
            }
            throw e;
        }
        try {
            if (this.mcWrapper.isConnectionSynchronizationProvider()) {
                throw new NotSupportedException();
            }
            if (this.mcWrapper.isEnlistmentDisabled()) {
                if (isTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Managed connection isEnlistmentDisabled is true.", (Object[])new Object[0]);
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Returning without registering.", (Object[])new Object[0]);
                }
                if (isTracingEnabled && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"addSync", (Object)false);
                }
                return false;
            }
            EmbeddableWebSphereTransactionManager tranMgr = this.mcWrapper.pm.connectorSvc.transactionManager;
            tranMgr.registerSynchronization(uowCoord, (Synchronization)this);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.addSync", (String)"237", (Object)this);
            Object[] parms = new Object[]{"addSync", e, "ResourceException"};
            Tr.error((TraceComponent)tc, (String)"REGISTER_WITH_SYNCHRONIZATION_EXCP_J2CA0026", (Object[])parms);
            ResourceException re = new ResourceException("addSync: caught Exception");
            re.initCause((Throwable)e);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"addSync", (Object)e);
            }
            throw re;
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"addSync", (Object)true);
        }
        return true;
    }

    public void afterCompletion(int status) {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"afterCompletion", (Object[])new Object[0]);
        }
        this.hasRollbackOccured = false;
        if (isTracingEnabled && tc.isDebugEnabled() && this.mcWrapper.getHandleCount() != 0 && isTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Information:  handle not closed at end of UOW for resource " + this.mcWrapper.gConfigProps.cfName), (Object[])new Object[0]);
        }
        if (this.mcWrapper.isMCAborted()) {
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"afterCompletion", (Object)"aborted");
            }
            return;
        }
        this.mcWrapper.transactionComplete();
        boolean shareable = this.mcWrapper.getConnectionManager().shareable();
        if (shareable || !shareable && this.mcWrapper.getHandleCount() == 0 || this.mcWrapper.isStale()) {
            if (isTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Releasing the connection to the pool. shareable = " + shareable + "  handleCount = " + this.mcWrapper.getHandleCount() + "  isStale = " + this.mcWrapper.isStale()), (Object[])new Object[0]);
            }
            try {
                this.mcWrapper.releaseToPoolManager();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.afterCompletion", (String)"291", (Object)this);
                if (isTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("afterCompletionCode for resource " + this.mcWrapper.gConfigProps.cfName + ":  caught Exception"), (Object[])new Object[]{e});
                }
            }
        } else {
            this.enlisted = false;
            this.mcWrapper.setUOWCoordinator(null);
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"afterCompletion");
        }
    }

    public void beforeCompletion() {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"beforeCompletion", (Object[])new Object[0]);
            Tr.exit((Object)this, (TraceComponent)tc, (String)"beforeCompletion");
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"commit", (Object[])new Object[0]);
        }
        try {
            this.xaResource.commit(xid, onePhase);
        }
        catch (XAException e) {
            this.processXAException(e);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.commit", (String)"378", (Object)this);
            if (!this.mcWrapper.isStale()) {
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", (Object[])new Object[]{"commit", xid, e, this.mcWrapper.gConfigProps.cfName});
            }
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)e);
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.commit", (String)"384", (Object)this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", (Object[])new Object[]{"commit", xid, e, this.mcWrapper.gConfigProps.cfName});
            }
            XAException xae = new XAException(-7);
            xae.initCause(e);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)e);
            }
            throw xae;
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"commit");
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"end", (Object[])new Object[0]);
        }
        if (this.getMcWrapper().isMCAborted()) {
            Tr.exit((TraceComponent)tc, (String)"Connection was aborted. Exiting end.");
            return;
        }
        try {
            this.xaResource.end(xid, flags);
        }
        catch (XAException e) {
            this.processXAException(e);
            if (flags != 0x20000000 || e.errorCode < 100 || e.errorCode > 107) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.end", (String)"417", (Object)this);
                if (!this.mcWrapper.isStale()) {
                    Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", (Object[])new Object[]{"end", xid, e, this.mcWrapper.gConfigProps.cfName});
                }
                if (isTracingEnabled && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"end", (Object)e);
                }
                throw e;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.end", (String)"423", (Object)this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", (Object[])new Object[]{"end", xid, e, this.mcWrapper.gConfigProps.cfName});
            }
            XAException xae = new XAException(-7);
            xae.initCause(e);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"end", (Object)xae);
            }
            throw xae;
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"end");
        }
    }

    @Override
    public void enlist() throws ResourceException {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"enlist", (Object[])new Object[]{this.mcWrapper.getUOWCoordinator()});
        }
        if (this.hasRollbackOccured) {
            ResourceException x = new ResourceException("Attempt to continue working after transaction rolledback !");
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlist", (Object)"It is NOT valid to continue working under a transaction that has already rolledback");
            }
            throw x;
        }
        if (this.enlisted) {
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist", (Object)"already enlisted");
            }
            return;
        }
        try {
            int branchCoupling = this.mcWrapper.getCm().getResourceRefInfo().getBranchCoupling();
            int startFlag = 0;
            if (branchCoupling != -1 && (startFlag = this.mcWrapper.getCm().supportsBranchCoupling(branchCoupling, this.mcWrapper.get_managedConnectionFactory())) == -1) {
                throw new ResourceException("Branch coupling attribute not implemented for this resource");
            }
            int recoveryToken = this.mcWrapper.getRecoveryToken();
            EmbeddableWebSphereTransactionManager tranMgr = this.mcWrapper.pm.connectorSvc.transactionManager;
            if (!tranMgr.enlist(this.mcWrapper.getUOWCoordinator(), (XAResource)this, recoveryToken, startFlag)) {
                Tr.error((TraceComponent)tc, (String)"BAD_RETURN_VALUE_FROM_ENLIST_J2CA0087", (Object[])new Object[]{this, this.mcWrapper.gConfigProps.cfName});
                ResourceException x = new ResourceException("Error on enlist");
                if (isTracingEnabled && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist", (Object)((Object)x));
                }
                throw x;
            }
        }
        catch (ResourceException e) {
            block19: {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.enlist", (String)"535", (Object)this);
                Tr.error((TraceComponent)tc, (String)"ENLIST_RESOURCE_EXCP_J2CA0030", (Object[])new Object[]{"enlist", e, "ResourceException", this.mcWrapper.gConfigProps.cfName});
                this.mcWrapper.markTransactionError();
                try {
                    EmbeddableWebSphereTransactionManager tranMgr = this.mcWrapper.pm.connectorSvc.transactionManager;
                    tranMgr.getTransaction().setRollbackOnly();
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.j2c.XATransactionWrapper.enlist", (String)"630", (Object)this);
                    if (!isTracingEnabled || !tc.isEventEnabled()) break block19;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Caught Exception while trying to mark transaction RollbackOnly - Exception:" + ex), (Object[])new Object[0]);
                }
            }
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist", (Object)((Object)e));
            }
            throw e;
        }
        catch (Exception e) {
            block20: {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.enlist", (String)"546", (Object)this);
                String pmiName = null;
                if (this.mcWrapper != null) {
                    pmiName = this.mcWrapper.gConfigProps.cfName;
                }
                Object[] parms = new Object[]{"enlist", e, "ResourceException", pmiName};
                Tr.error((TraceComponent)tc, (String)"ENLIST_RESOURCE_EXCP_J2CA0030", (Object[])parms);
                this.mcWrapper.markTransactionError();
                try {
                    EmbeddableWebSphereTransactionManager tranMgr = this.mcWrapper.pm.connectorSvc.transactionManager;
                    tranMgr.getTransaction().setRollbackOnly();
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.j2c.XATransactionWrapper.enlist", (String)"663", (Object)this);
                    if (!isTracingEnabled || !tc.isEventEnabled()) break block20;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Caught Exception while trying to mark transaction RollbackOnly - Exception:" + ex), (Object[])new Object[0]);
                }
            }
            ResourceException re = new ResourceException("enlist: caught Exception");
            re.initCause((Throwable)e);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist", (Object)e);
            }
            throw re;
        }
        this.enlisted = true;
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist");
        }
    }

    @Override
    public void delist() throws ResourceException {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"delist", (Object[])new Object[]{this.mcWrapper.getUOWCoordinator()});
        }
        this.enlisted = false;
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"delist");
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"forget", (Object[])new Object[0]);
        }
        try {
            this.xaResource.forget(xid);
        }
        catch (XAException e) {
            this.processXAException(e);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.forget", (String)"561", (Object)this);
            if (!this.mcWrapper.isStale()) {
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", (Object[])new Object[]{"forget", xid, e, this.mcWrapper.gConfigProps.cfName});
            }
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"forget", (Object)e);
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.forget", (String)"567", (Object)this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", (Object[])new Object[]{"forget", xid, e, this.mcWrapper.gConfigProps.cfName});
            }
            XAException xae = new XAException(-7);
            xae.initCause(e);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"forget", (Object)e);
            }
            throw xae;
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"forget");
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionTimeout", (Object[])new Object[0]);
        }
        int rc = -1;
        try {
            rc = this.xaResource.getTransactionTimeout();
        }
        catch (XAException e) {
            this.processXAException(e);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.getTransactionTimeout", (String)"611", (Object)this);
            if (!this.mcWrapper.isStale()) {
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", (Object[])new Object[]{"getTransactionTimeout", e, this.mcWrapper.gConfigProps.cfName});
            }
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionTimeout", (Object)e);
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.getTransactionTimeout", (String)"618", (Object)this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", (Object[])new Object[]{"getTransactionTimeout", e, this.mcWrapper.gConfigProps.cfName});
            }
            XAException xae = new XAException(-7);
            xae.initCause(e);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionTimeout", (Object)e);
            }
            throw xae;
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionTimeout", (Object)rc);
        }
        return rc;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"isSameRM", (Object[])new Object[0]);
        }
        boolean rc = false;
        try {
            rc = this.xaResource.isSameRM(xares);
        }
        catch (XAException e) {
            this.processXAException(e);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.isSameRM", (String)"648", (Object)this);
            if (!this.mcWrapper.isStale()) {
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", (Object[])new Object[]{"isSameRM", e, this.mcWrapper.gConfigProps.cfName});
            }
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"isSameRM", (Object)e);
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.isSameRM", (String)"655", (Object)this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", (Object[])new Object[]{"isSameRM", e, this.mcWrapper.gConfigProps.cfName});
            }
            XAException xae = new XAException(-7);
            xae.initCause(e);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"isSameRM", (Object)e);
            }
            throw xae;
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"isSameRM", (Object)rc);
        }
        return rc;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"prepare", (Object[])new Object[0]);
        }
        int rc = -1;
        try {
            rc = this.xaResource.prepare(xid);
        }
        catch (XAException e) {
            this.processXAException(e);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.prepare", (String)"686", (Object)this);
            if (!this.mcWrapper.isStale()) {
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", (Object[])new Object[]{"prepare", xid, e, this.mcWrapper.gConfigProps.cfName});
            }
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)e);
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.prepare", (String)"692", (Object)this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", (Object[])new Object[]{"prepare", xid, e, this.mcWrapper.gConfigProps.cfName});
            }
            XAException xae = new XAException(-7);
            xae.initCause(e);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)e);
            }
            throw xae;
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)rc);
        }
        return rc;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        Xid[] rc;
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"recover", (Object[])new Object[0]);
        }
        try {
            rc = this.xaResource.recover(flag);
        }
        catch (XAException e) {
            this.processXAException(e);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.recover", (String)"722", (Object)this);
            if (!this.mcWrapper.isStale()) {
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", (Object[])new Object[]{"recover", e, this.mcWrapper.gConfigProps.cfName});
            }
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"recover", (Object)e);
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.recover", (String)"728", (Object)this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", (Object[])new Object[]{"recover", e, this.mcWrapper.gConfigProps.cfName});
            }
            XAException xae = new XAException(-7);
            xae.initCause(e);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"recover", (Object)e);
            }
            throw xae;
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"recover", (Object)rc);
        }
        return rc;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object[])new Object[0]);
        }
        if (this.getMcWrapper().isMCAborted()) {
            Tr.exit((TraceComponent)tc, (String)"Connection was aborted. Exiting rollback.");
            return;
        }
        this.hasRollbackOccured = true;
        try {
            this.xaResource.rollback(xid);
        }
        catch (XAException e) {
            this.processXAException(e);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.rollback", (String)"755", (Object)this);
            if (!this.mcWrapper.isStale()) {
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", (Object[])new Object[]{"rollback", xid, e, this.mcWrapper.gConfigProps.cfName});
            }
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)e);
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.rollback", (String)"761", (Object)this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", (Object[])new Object[]{"rollback", xid, e, this.mcWrapper.gConfigProps.cfName});
            }
            XAException x = new XAException("Exception:" + e.toString());
            x.initCause(e);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)x);
            }
            throw x;
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setTransactionTimeout", (Object[])new Object[0]);
        }
        boolean rc = false;
        try {
            rc = this.xaResource.setTransactionTimeout(seconds);
        }
        catch (XAException e) {
            this.processXAException(e);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.setTransactionTimeout", (String)"790", (Object)this);
            if (!this.mcWrapper.isStale()) {
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", (Object[])new Object[]{"setTransactionTimeout", e, this.mcWrapper.gConfigProps.cfName});
            }
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"setTransactionTimeout", (Object)e);
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.setTransactionTimeout", (String)"796", (Object)this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", (Object[])new Object[]{"setTransactionTimeout", e, this.mcWrapper.gConfigProps.cfName});
            }
            XAException x = new XAException("Exception:" + e.toString());
            x.initCause(e);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"setTransactionTimeout", (Object)e);
            }
            throw x;
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setTransactionTimeout", (Object)rc);
        }
        return rc;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object[])new Object[0]);
        }
        try {
            this.xaResource.start(xid, flags);
        }
        catch (XAException e) {
            this.processXAException(e);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.start", (String)"824", (Object)this);
            if (!this.mcWrapper.isStale()) {
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", (Object[])new Object[]{"start", xid, e, this.mcWrapper.gConfigProps.cfName});
            }
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)e);
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.XATransactionWrapper.start", (String)"830", (Object)this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                Tr.error((TraceComponent)tc, (String)"XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", (Object[])new Object[]{"start", xid, e, this.mcWrapper.gConfigProps.cfName});
            }
            XAException xae = new XAException(-7);
            xae.initCause(e);
            if (isTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)e);
            }
            throw xae;
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public void processXAException(XAException xae) {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (xae.errorCode == -3 || xae.errorCode == -7) {
            if (isTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"processXAException: detecting bad XAException error code. Marking MCWrapper stale. ", (Object[])new Object[0]);
            }
            this.mcWrapper.markTransactionError();
        }
        if (xae.errorCode != 0 && isTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"processXAException: Non-zero return code from XAResource. Return code is:  ", (Object[])new Object[]{XATransactionWrapper.getXAExceptionCodeString(xae.errorCode)});
        }
    }

    public static String getXAExceptionCodeString(int code) {
        switch (code) {
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "UNKNOWN XA EXCEPTION CODE: " + code;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(256);
        buf.append("XATransactionWrapper@ ");
        buf.append(Integer.toHexString(this.hashCode()));
        buf.append("  XAResource: ");
        buf.append(this.xaResource);
        buf.append("  enlisted: ");
        buf.append(this.enlisted);
        buf.append("Has Tran Rolled Back = ");
        buf.append(this.hasRollbackOccured);
        buf.append("  mcWrapper.hashCode()");
        buf.append(this.mcWrapper.hashCode());
        return buf.toString();
    }

    public MCWrapper getMcWrapper() {
        return this.mcWrapper;
    }

    @Override
    public boolean isRRSTransactional() {
        return false;
    }
}

