/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.impl.PartnerLogTable;
import com.ibm.tx.jta.impl.RecoveryManager;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.util.Utils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.FailureScopeLifeCycle;
import com.ibm.ws.Transaction.JTA.FailureScopeLifeCycleHelper;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.CpuInfo;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.SystemException;

public class FailureScopeController {
    private static final TraceComponent tc = Tr.register(FailureScopeController.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected volatile FailureScope _failureScope;
    protected String _serverName;
    protected RecoveryLog _tranLog;
    protected RecoveryLog _xaLog;
    protected RecoveryLog _recoverXaLog;
    protected PartnerLogTable _partnerLogTable;
    protected boolean _localFailureScope;
    protected RecoveryManager _recoveryManager;
    protected FailureScopeLifeCycle _fslc;
    protected Set<TransactionImpl> _transactions;
    private static final int SMP_THRESH = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            return Integer.getInteger("com.ibm.tx.jta.FailureScopeController.SMP_THRESH", 4);
        }
    });
    protected static final boolean isConcurrent = CpuInfo.getAvailableProcessors().get() > SMP_THRESH;

    protected FailureScopeController() {
    }

    public FailureScopeController(FailureScope fs) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"FailureScopeController", (Object[])new Object[]{fs});
        }
        this._failureScope = fs;
        this._serverName = fs.serverName();
        this._transactions = isConcurrent ? Utils.createConcurrentSet() : new HashSet<TransactionImpl>();
        this._localFailureScope = this._serverName.equals(Configuration.getServerName());
        this._partnerLogTable = new PartnerLogTable(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"FailureScopeController", (Object)this);
        }
    }

    public RecoveryLog getTransactionLog() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTransactionLog", (Object[])new Object[]{this, this._tranLog});
        }
        return this._tranLog;
    }

    public RecoveryLog getPartnerLog() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getPartnerLog", (Object[])new Object[]{this, this._xaLog});
        }
        return this._xaLog;
    }

    public PartnerLogTable getPartnerLogTable() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getPartnerLogTable", (Object[])new Object[]{this, this._partnerLogTable});
        }
        return this._partnerLogTable;
    }

    public boolean localFailureScope() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"localFailureScope", (Object[])new Object[]{this, this._localFailureScope});
        }
        return this._localFailureScope;
    }

    public String serverName() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"serverName", (Object[])new Object[]{this, this._serverName});
        }
        return this._serverName;
    }

    public void createRecoveryManager(RecoveryAgent agent, RecoveryLog tranLog, RecoveryLog xaLog, RecoveryLog recoverXaLog, byte[] defaultApplId, int defaultEpoch) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoveryManager", (Object[])new Object[]{this, agent, tranLog, xaLog, recoverXaLog, defaultApplId, defaultEpoch});
        }
        this._tranLog = tranLog;
        this._xaLog = xaLog;
        this._recoverXaLog = recoverXaLog;
        this._recoveryManager = new RecoveryManager(this, agent, tranLog, xaLog, recoverXaLog, defaultApplId, defaultEpoch);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoveryManager", (Object)this._recoveryManager);
        }
    }

    public RecoveryManager getRecoveryManager() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRecoveryManager", (Object[])new Object[]{this, this._recoveryManager});
        }
        return this._recoveryManager;
    }

    public void shutdown(boolean immediate) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown", (Object[])new Object[]{this, this._failureScope, immediate});
        }
        if (immediate && !this._localFailureScope) {
            IllegalArgumentException iae = new IllegalArgumentException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"shutdown", (Object[])new Object[]{iae});
            }
            FFDCFilter.processException((Throwable)iae, (String)"com.ibm.tx.jta.impl.FailureScopeController.shutdown", (String)"419", (Object)this);
            throw iae;
        }
        if (!(immediate || this._recoveryManager != null && this._recoveryManager.recoveryPrevented())) {
            if (this._recoveryManager != null) {
                this._recoveryManager.prepareToShutdown();
            }
            FailureScopeLifeCycleHelper.removeFromActiveList(this._fslc);
            if (this._localFailureScope) {
                this._partnerLogTable.terminate();
                TransactionImpl[] runningTransactions = this.getAllTransactions();
                boolean transactionsLeft = runningTransactions != null && runningTransactions.length > 0;
                boolean partnersLeft = true;
                try {
                    PartnerLogTable plt = null;
                    if (this._recoveryManager != null) {
                        this._recoveryManager.preShutdown(transactionsLeft);
                        plt = this._recoveryManager.getPartnerLogTable();
                    }
                    partnersLeft = this.shutdown(runningTransactions, plt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this._recoveryManager != null) {
                    this._recoveryManager.postShutdown(partnersLeft);
                }
                if (!(partnersLeft || this._tranLog == null || this._tranLog.failed() || this._xaLog == null || this._xaLog.failed())) {
                    Tr.audit((TraceComponent)tc, (String)"WTRN0105_CLEAN_SHUTDOWN", (Object[])new Object[0]);
                    if (this._recoveryManager != null && com.ibm.ws.recoverylog.spi.Configuration.HAEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Peer recovery enabled, do housekeeping", (Object[])new Object[0]);
                        }
                        this._recoveryManager.updateServerLease(this.serverName());
                        this._recoveryManager.deleteRecoveryLogsIfPeerRecoveryEnv();
                        this._recoveryManager.deleteServerLease(this.serverName());
                    }
                } else if (partnersLeft && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Not a clean shutdown", (Object[])new Object[]{immediate, this._localFailureScope});
                }
                if (this._tranLog != null && this._tranLog.failed() || this._xaLog != null && this._xaLog.failed()) {
                    Tr.audit((TraceComponent)tc, (String)"WTRN0153_INVALID_LOG_AT_SHUTDOWN", (Object[])new Object[0]);
                }
            } else if (this._recoveryManager != null) {
                this._recoveryManager.cleanupRemoteFailureScope();
            }
            this._tranLog = null;
            this._xaLog = null;
            this._recoverXaLog = null;
            this._recoveryManager = null;
            this._failureScope = null;
            this._serverName = null;
            this._partnerLogTable = null;
            this._fslc = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    protected boolean shutdown(TransactionImpl[] runningTransactions, PartnerLogTable plt) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown", (Object[])new Object[]{runningTransactions, plt});
        }
        if (runningTransactions != null) {
            for (TransactionImpl tx : runningTransactions) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Transaction " + tx + " is still active"), (Object[])new Object[0]);
                }
                tx.shutdown();
            }
        }
        if (plt != null) {
            this._partnerLogTable.merge(plt);
        }
        boolean result = this._partnerLogTable.shutdown();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTransaction(TransactionImpl tran, boolean recovered) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerTransaction", (Object[])new Object[]{this, tran, recovered});
        }
        if (isConcurrent) {
            this._transactions.add(tran);
        }
        if (!isConcurrent || recovered) {
            FailureScopeController failureScopeController = this;
            synchronized (failureScopeController) {
                if (!isConcurrent) {
                    this._transactions.add(tran);
                }
                if (recovered) {
                    this._recoveryManager.registerTransaction(tran);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterTransaction(TransactionImpl tran, boolean recovered) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deregisterTransaction", (Object[])new Object[]{this, tran, recovered});
        }
        if (isConcurrent) {
            this._transactions.remove(tran);
        }
        if (!isConcurrent || recovered) {
            FailureScopeController failureScopeController = this;
            synchronized (failureScopeController) {
                if (!isConcurrent) {
                    this._transactions.remove(tran);
                }
                if (recovered) {
                    this._recoveryManager.deregisterTransaction(tran);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deregisterTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionImpl[] getAllTransactions() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAllTransactions", (Object[])new Object[]{this});
        }
        TransactionImpl[] transactionArray = null;
        FailureScopeController failureScopeController = this;
        synchronized (failureScopeController) {
            int numTransactions = this._transactions.size();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found " + numTransactions + " active transaction(s)"), (Object[])new Object[0]);
            }
            transactionArray = new TransactionImpl[numTransactions];
            this._transactions.toArray(transactionArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAllTransactions", (Object)transactionArray);
        }
        return transactionArray;
    }

    public FailureScope failureScope() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"failureScope", (Object[])new Object[]{this._failureScope});
        }
        return this._failureScope;
    }

    public void setFailureScopeLifeCycle(FailureScopeLifeCycle fslc) {
        this._fslc = fslc;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setFailureScopeLifeCycle", (Object[])new Object[]{this._fslc});
        }
    }
}

