/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.main;

import com.ibm.ws.ras.instrument.internal.bci.FFDCClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.JSR47TracingClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingClassAdapter;
import com.ibm.ws.ras.instrument.internal.introspect.TraceConfigClassVisitor;
import com.ibm.ws.ras.instrument.internal.main.AbstractInstrumentation;
import com.ibm.ws.ras.instrument.internal.main.FileLogger;
import com.ibm.ws.ras.instrument.internal.model.ClassInfo;
import com.ibm.ws.ras.instrument.internal.model.InstrumentationOptions;
import com.ibm.ws.ras.instrument.internal.model.PackageInfo;
import com.ibm.ws.ras.instrument.internal.model.TraceType;
import com.ibm.ws.ras.instrument.internal.xml.TraceConfigFileParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.SerialVersionUIDAdder;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

public class StaticTraceInstrumentation
extends AbstractInstrumentation {
    private static final String CLASS_NAME = "StaticTraceInstrumentation";
    protected boolean introspectAnnotations = true;
    protected boolean instrumentWithFFDC = false;
    protected boolean computeFrames = false;
    protected TraceType traceType = TraceType.TR;
    protected TraceConfigFileParser configFileParser = new TraceConfigFileParser();
    protected InstrumentationOptions instrumentationOptions = new InstrumentationOptions();

    public static boolean isLoggablePath(String path) {
        return FileLogger.isLoggablePath(path);
    }

    public PrintWriter fileWriter() {
        return FileLogger.fileWriter();
    }

    public byte[] read(InputStream inputStream) throws IOException {
        return FileLogger.read(inputStream);
    }

    public static void fileLog(String methodName, String text) {
        FileLogger.fileLog(CLASS_NAME, methodName, text);
    }

    public static void fileLog(String methodName, String text, Object value) {
        FileLogger.fileLog(CLASS_NAME, methodName, text, value);
    }

    public static void fileDump(String methodName, String text, byte[] bytes) {
        FileLogger.fileDump(CLASS_NAME, methodName, text, bytes);
    }

    public static void fileStack(String methodName, String text, Throwable th) {
        FileLogger.fileStack(CLASS_NAME, methodName, text, th);
    }

    public void setInstrumentWithFFDC(boolean instrumentWithFFDC) {
        this.instrumentWithFFDC = instrumentWithFFDC;
    }

    public boolean getInstrumentWithFFDC() {
        return this.instrumentWithFFDC;
    }

    public void setTraceType(TraceType traceType) {
        this.traceType = traceType;
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public void setComputeFrames(boolean computeFrames) {
        this.computeFrames = computeFrames;
    }

    public boolean isComputeFrames() {
        return this.computeFrames;
    }

    public InstrumentationOptions getInstrumentationOptions() {
        return this.instrumentationOptions;
    }

    public void setInstrumentationOptions(InstrumentationOptions instrumentationOptions) {
        this.instrumentationOptions = instrumentationOptions;
    }

    @Override
    protected final byte[] transform(String path, InputStream classStream) throws IOException {
        byte[] initialBytes;
        String methodName = "transform";
        boolean isLoggable = StaticTraceInstrumentation.isLoggablePath(path);
        if (isLoggable) {
            StaticTraceInstrumentation.fileLog(methodName, "Class", path);
        }
        try {
            initialBytes = this.read(classStream);
        }
        catch (IOException e) {
            StaticTraceInstrumentation.fileStack(methodName, "Read failure [ " + path + " ]", e);
            return null;
        }
        ClassInfo classInfo = this.readConfig(initialBytes);
        if (!this.getInstrumentationOptions().isPackageIncluded(classInfo.getPackageName())) {
            if (isLoggable) {
                StaticTraceInstrumentation.fileLog(methodName, "Ignore: Package not included", classInfo.getClassName());
            }
            return null;
        }
        classInfo = this.mergeClassConfigInfo(classInfo);
        if (isLoggable) {
            StaticTraceInstrumentation.fileDump(methodName, "Initial bytes", initialBytes);
        }
        ClassReader classReader = new ClassReader(initialBytes);
        ClassWriter classWriter = this.createWriter(classReader);
        ClassVisitor classVisitor = this.createVisitor(classInfo, classWriter, this.isDebug() || isLoggable);
        int readOptions = this.isComputeFrames() ? 8 : 0;
        try {
            classReader.accept(classVisitor, readOptions);
        }
        catch (Throwable t) {
            StaticTraceInstrumentation.fileStack(methodName, "Instrumentation failure [ " + path + " ]", t);
            if (!this.isDebug() && !isLoggable) {
                classReader = new ClassReader(initialBytes);
                classWriter = this.createWriter(classReader);
                classVisitor = this.createVisitor(classInfo, classWriter, true);
                try {
                    classReader.accept(classVisitor, readOptions);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new IOException("Unable to instrument class stream with trace", t);
        }
        byte[] finalBytes = classWriter.toByteArray();
        if (isLoggable) {
            StaticTraceInstrumentation.fileDump(methodName, "Final bytes", initialBytes);
        }
        return finalBytes;
    }

    private ClassInfo readConfig(byte[] classBytes) {
        TraceConfigClassVisitor classVisitor = new TraceConfigClassVisitor();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept((ClassVisitor)classVisitor, 0);
        return classVisitor.getClassInfo();
    }

    @Override
    public void processPackageInfo() throws IOException {
        if (!this.introspectAnnotations) {
            return;
        }
        super.processPackageInfo();
    }

    protected ClassInfo mergeClassConfigInfo(ClassInfo classInfo) {
        PackageInfo packageInfo = this.configFileParser.getPackageInfo(classInfo.getInternalPackageName());
        if (packageInfo == null) {
            packageInfo = this.getPackageInfo(classInfo.getInternalPackageName());
        }
        classInfo.updateDefaultValuesFromPackageInfo(packageInfo);
        ClassInfo ci = this.configFileParser.getClassInfo(classInfo.getInternalClassName());
        if (ci != null) {
            classInfo.overrideValuesFromExplicitClassInfo(ci);
        }
        return classInfo;
    }

    private ClassWriter createWriter(ClassReader classReader) {
        int writeOptions = this.isComputeFrames() ? 2 : 1;
        return new ClassWriter(classReader, writeOptions);
    }

    private ClassVisitor createVisitor(ClassInfo classInfo, ClassWriter classWriter, boolean isLoggable) {
        TraceType useTraceType;
        Object visitor = classWriter;
        if (isLoggable) {
            PrintWriter traceWriter;
            visitor = new CheckClassAdapter((ClassVisitor)visitor);
            PrintWriter printWriter = traceWriter = isLoggable ? this.fileWriter() : null;
            if (traceWriter == null) {
                traceWriter = new PrintWriter(System.out);
            }
            visitor = new TraceClassVisitor((ClassVisitor)visitor, traceWriter);
        }
        if ((useTraceType = this.getTraceType()) == TraceType.JAVA_LOGGING) {
            visitor = new JSR47TracingClassAdapter((ClassVisitor)visitor, classInfo);
        } else if (useTraceType == TraceType.TR) {
            visitor = new WebSphereTrTracingClassAdapter((ClassVisitor)visitor, classInfo);
        }
        if (this.getInstrumentWithFFDC()) {
            visitor = new FFDCClassAdapter((ClassVisitor)visitor, classInfo);
        }
        visitor = new SerialVersionUIDAdder((ClassVisitor)visitor);
        return visitor;
    }

    @Override
    public void processArguments(String[] args) throws IOException {
        int i;
        ArrayList<File> classFiles = new ArrayList<File>();
        ArrayList<File> jarFiles = new ArrayList<File>();
        String[] fileArgs = null;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("--config")) {
                this.configFileParser = new TraceConfigFileParser(new File(args[++i]));
                this.configFileParser.parse();
                InstrumentationOptions options = this.configFileParser.getInstrumentationOptions();
                if (options.getAddFFDC()) {
                    this.setInstrumentWithFFDC(true);
                }
                this.setTraceType(options.getTraceType());
                this.setInstrumentationOptions(options);
                continue;
            }
            if (args[i].equalsIgnoreCase("--debug") || args[i].equals("-d")) {
                this.setDebug(true);
                continue;
            }
            if (args[i].equalsIgnoreCase("--tr")) {
                this.setTraceType(TraceType.TR);
                continue;
            }
            if (args[i].equalsIgnoreCase("--websphere")) {
                this.setTraceType(TraceType.TR);
                continue;
            }
            if (args[i].equalsIgnoreCase("--java-logging")) {
                this.setTraceType(TraceType.JAVA_LOGGING);
                continue;
            }
            if (args[i].equalsIgnoreCase("--jsr47")) {
                this.setTraceType(TraceType.JAVA_LOGGING);
                continue;
            }
            if (args[i].equalsIgnoreCase("--none")) {
                this.setTraceType(TraceType.NONE);
                continue;
            }
            if (args[i].equalsIgnoreCase("--no-trace")) {
                this.setTraceType(TraceType.NONE);
                continue;
            }
            if (args[i].equalsIgnoreCase("--ffdc")) {
                this.setInstrumentWithFFDC(true);
                continue;
            }
            if (args[i].equalsIgnoreCase("--compute-frames")) {
                this.setComputeFrames(true);
                continue;
            }
            fileArgs = new String[args.length - i];
            System.arraycopy(args, i, fileArgs, 0, fileArgs.length);
            break;
        }
        if (fileArgs == null || fileArgs.length == 0) {
            throw new IllegalArgumentException("Empty file lists are illegal");
        }
        for (i = 0; i < fileArgs.length; ++i) {
            File f = new File((String)fileArgs[i]);
            if (!f.exists()) {
                throw new IllegalArgumentException(f + " does not exist");
            }
            if (f.isDirectory()) {
                classFiles.addAll(this.getClassFiles(f, null));
                continue;
            }
            if (f.getName().endsWith(".class")) {
                classFiles.add(f);
                continue;
            }
            if (f.getName().endsWith(".jar")) {
                jarFiles.add(f);
                continue;
            }
            if (f.getName().endsWith(".zip")) {
                jarFiles.add(f);
                continue;
            }
            System.err.println(f + " is an unexpected file type; ignoring");
        }
        this.setClassFiles(classFiles);
        this.setJarFiles(jarFiles);
    }

    private static void printUsageMessage() {
        System.out.println("Description:");
        System.out.println("  StaticTraceInstrumentation can modify classes");
        System.out.println("  in place to add calls to a trace framework that will");
        System.out.println("  delegate to JSR47 logging or WebSphere Tr.");
        System.out.println("");
        System.out.println("Required arguments:");
        System.out.println("  The paths to one or more binary classes, jars, or");
        System.out.println("  directories to scan for classes and jars are required");
        System.out.println("  parameters.");
        System.out.println("");
        System.out.println("  Class files must have a .class extension.");
        System.out.println("  Jar files must have a .jar or a .zip extension.");
        System.out.println("  Directories are recursively scanned for .jar, .zip, and");
        System.out.println("  .class files to instrument.");
    }

    public static final void main(String[] args) throws Exception {
        if (args == null || args.length <= 0) {
            StaticTraceInstrumentation.printUsageMessage();
            return;
        }
        StaticTraceInstrumentation sti = new StaticTraceInstrumentation();
        sti.processArguments(args);
        sti.processPackageInfo();
        sti.executeInstrumentation();
    }

    static {
        StaticTraceInstrumentation.fileLog("<init>", "Initializing");
    }
}

