/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.monitor;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.monitor.meters.MeterCollection;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxrs.monitor.MonitorAppStateListener;
import com.ibm.ws.jaxrs.monitor.REST_Stats;
import com.ibm.ws.jaxrs.monitor.RestMonitorKeyCache;
import com.ibm.ws.jaxrs.monitor.RestRouteCache;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;

@Monitor(group={"REST"})
@Provider
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxRsMonitorFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final TraceComponent tc = Tr.register(JaxRsMonitorFilter.class, null, null);
    private static final String REST_HTTP_ROUTE_ATTR = "REST.HTTP.ROUTE";
    @Context
    ResourceInfo resourceInfo;
    @Context
    HttpServletRequest servletRequest;
    @PublishedMetric
    public final MeterCollection<REST_Stats> jaxRsCountByName = new MeterCollection("REST", (Object)this);
    static final ConcurrentHashMap<String, RestMetricInfo> appMetricInfos = new ConcurrentHashMap();
    static final Set<JaxRsMonitorFilter> instances = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final RestMonitorKeyCache monitorKeyCache = new RestMonitorKeyCache();
    private static final String STATS_CONTEXT = "REST_Stats_Context";
    private static final RestRouteCache ROUTE_CACHE = new RestRouteCache();
    static final long serialVersionUID = -3084616802103043488L;

    @PostConstruct
    public void postConstruct() {
        instances.add(this);
    }

    @PreDestroy
    public void preDestroy() {
        instances.remove(this);
    }

    public void filter(ContainerRequestContext reqCtx) throws IOException {
        String route;
        Class resourceClass = this.resourceInfo.getResourceClass();
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        if (resourceClass != null && resourceMethod != null && (route = JaxRsMonitorFilter.getRoute(reqCtx, resourceClass, resourceMethod)) != null && !route.isEmpty()) {
            this.servletRequest.setAttribute(REST_HTTP_ROUTE_ATTR, (Object)route);
        }
        if (!MonitorAppStateListener.isRESTEnabled()) {
            return;
        }
        if (resourceClass != null && resourceMethod != null) {
            RestMonitorKeyCache.MonitorKey monitorKey = monitorKeyCache.getMonitorKey(resourceClass, resourceMethod);
            if (monitorKey == null) {
                Class<?>[] parameterClasses = resourceMethod.getParameterTypes();
                int i = 0;
                String fullMethodName = resourceClass.getName() + "/" + resourceMethod.getName() + "(";
                for (Class<?> p : parameterClasses) {
                    String parameter = p.getCanonicalName();
                    fullMethodName = i > 0 ? fullMethodName + "_" + parameter : fullMethodName + parameter;
                    ++i;
                }
                fullMethodName = fullMethodName + ")";
                ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                String appName = this.getAppName(cmd);
                String modName = this.getModName(cmd);
                String keyPrefix = this.createKeyPrefix(appName, modName);
                String key = keyPrefix + "/" + fullMethodName;
                monitorKey = new RestMonitorKeyCache.MonitorKey(key, keyPrefix, fullMethodName);
                this.addKeyToMetricInfo(appName, key);
                monitorKeyCache.putMonitorKey(resourceClass, resourceMethod, monitorKey);
            }
            reqCtx.setProperty(STATS_CONTEXT, (Object)new StatsContext(monitorKey, System.nanoTime()));
        }
    }

    public void filter(ContainerRequestContext reqCtx, ContainerResponseContext respCtx) throws IOException {
        String metricsHeader;
        REST_Stats stats;
        if (!MonitorAppStateListener.isRESTEnabled()) {
            return;
        }
        StatsContext statsContext = (StatsContext)reqCtx.getProperty(STATS_CONTEXT);
        if (statsContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ContainerRequestContext.filter() has not been invoked for " + reqCtx.getUriInfo().getPath()), (Object[])new Object[0]);
            }
            return;
        }
        long elapsedTime = System.nanoTime() - statsContext.startTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Elapsed time for " + statsContext.monitorKey.statsKey + " is " + elapsedTime + " ns"), (Object[])new Object[0]);
        }
        if ((stats = (REST_Stats)this.jaxRsCountByName.get(statsContext.monitorKey.statsKey)) == null) {
            stats = this.initJaxRsStats(statsContext.monitorKey.statsKey, statsContext.monitorKey.statsKeyPrefix, statsContext.monitorKey.statsMethodName);
            if (MonitorAppStateListener.restMetricCallback != null) {
                MonitorAppStateListener.restMetricCallback.createRestMetric(statsContext.monitorKey.statsMethodName, statsContext.monitorKey.statsKey);
            }
        }
        if ((metricsHeader = respCtx.getHeaderString("com.ibm.ws.microprofile.metrics.monitor.MetricsJaxRsEMCallbackImpl.Exception")) == null) {
            metricsHeader = respCtx.getHeaderString("io.openliberty.microprofile.metrics.internal.monitor.MetricsJaxRsEMCallbackImpl.Exception");
        }
        if (metricsHeader == null) {
            metricsHeader = respCtx.getHeaderString("io.openliberty.restfulws.mpmetrics.MetricsRestfulWsEMCallbackImpl.Exception");
        }
        if (metricsHeader == null) {
            if (MonitorAppStateListener.restMetricCallback != null) {
                MonitorAppStateListener.restMetricCallback.updateRestMetric(statsContext.monitorKey.statsMethodName, statsContext.monitorKey.statsKey, Duration.ofNanos(elapsedTime));
            }
            this.maybeStartNewMinute(stats);
            stats.incrementCountBy(1);
            stats.updateRT(elapsedTime < 0L ? 0L : elapsedTime);
            if (elapsedTime >= 0L) {
                long minuteLatestMaximumDuration = stats.getMinuteLatestMaximumDuration();
                while (elapsedTime > minuteLatestMaximumDuration && !stats.compareAndUpdateMinuteLatestMaximumDuration(minuteLatestMaximumDuration, elapsedTime)) {
                    minuteLatestMaximumDuration = stats.getMinuteLatestMaximumDuration();
                }
                long minuteLatestMinimumDuration = stats.getMinuteLatestMinimumDuration();
                if (elapsedTime != 0L || minuteLatestMinimumDuration != 0L) {
                    while (!(elapsedTime >= minuteLatestMinimumDuration && minuteLatestMinimumDuration != 0L || stats.compareAndUpdateMinuteLatestMinimumDuration(minuteLatestMinimumDuration, elapsedTime))) {
                        minuteLatestMinimumDuration = stats.getMinuteLatestMinimumDuration();
                    }
                }
            }
        }
    }

    private static String getRoute(ContainerRequestContext request, Class<?> resourceClass, Method resourceMethod) {
        int checkResourceSize;
        String route = ROUTE_CACHE.getRoute(resourceClass, resourceMethod);
        if (route == null && (checkResourceSize = request.getUriInfo().getMatchedResources().size()) == 1) {
            String contextRoot = request.getUriInfo().getBaseUri().getPath();
            UriBuilder template = UriBuilder.fromPath((String)contextRoot);
            if (resourceClass.isAnnotationPresent(Path.class)) {
                template.path(resourceClass);
            }
            if (resourceMethod.isAnnotationPresent(Path.class)) {
                template.path(resourceMethod);
            }
            route = template.toTemplate();
            ROUTE_CACHE.putRoute(resourceClass, resourceMethod, route);
        }
        return route;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeStartNewMinute(REST_Stats stats) {
        long newMinute = this.getCurrentMinuteFromSystem();
        if (newMinute > stats.getMinuteLatest()) {
            JaxRsMonitorFilter jaxRsMonitorFilter = this;
            synchronized (jaxRsMonitorFilter) {
                if (newMinute > stats.getMinuteLatest()) {
                    stats.updateMinutePreviousMaximumDuration(stats.getMinuteLatestMaximumDuration());
                    stats.updateMinutePreviousMinimumDuration(stats.getMinuteLatestMinimumDuration());
                    stats.updateMinutePrevious(stats.getMinuteLatest());
                    stats.updateMinuteLatestMaximumDuration(0L);
                    stats.updateMinuteLatestMinimumDuration(0L);
                    stats.updateMinuteLatest(newMinute);
                }
            }
        }
    }

    private long getCurrentMinuteFromSystem() {
        return System.currentTimeMillis() / 60000L;
    }

    private synchronized REST_Stats initJaxRsStats(String key, String keyPrefix, String method) {
        REST_Stats nStats = (REST_Stats)this.jaxRsCountByName.get(key);
        if (nStats == null) {
            nStats = new REST_Stats(keyPrefix, method);
            this.jaxRsCountByName.put(key, (Object)nStats);
        }
        return nStats;
    }

    private String getModName(ComponentMetaData cmd) {
        ModuleMetaData mmd;
        String modName = null;
        if (cmd != null && (mmd = cmd.getModuleMetaData()) != null) {
            modName = mmd.getName();
        }
        return modName;
    }

    private String getAppName(ComponentMetaData cmd) {
        J2EEName j2name;
        String appName = null;
        if (cmd != null && (j2name = cmd.getJ2EEName()) != null) {
            appName = j2name.getApplication();
        }
        return appName;
    }

    private String createKeyPrefix(String appName, String modName) {
        if (JaxRsMonitorFilter.getMetricInfo((String)appName).isEar) {
            return appName + "/" + modName;
        }
        return modName;
    }

    static RestMetricInfo getMetricInfo(String appName) {
        RestMetricInfo rMetricInfo = appMetricInfos.get(appName);
        if (rMetricInfo == null) {
            rMetricInfo = new RestMetricInfo();
            appMetricInfos.put(appName, rMetricInfo);
        }
        return rMetricInfo;
    }

    private void addKeyToMetricInfo(String appName, String key) {
        RestMetricInfo rMetricInfo = appMetricInfos.get(appName);
        if (rMetricInfo != null) {
            rMetricInfo.setKey(key);
        }
    }

    static void cleanApplication(String appName) {
        RestMetricInfo rMetricInfo = appMetricInfos.get(appName);
        if (rMetricInfo != null) {
            HashSet<String> keys = rMetricInfo.getKeys();
            if (!keys.isEmpty()) {
                Iterator<String> keyIterator = keys.iterator();
                String key = null;
                while (keyIterator.hasNext()) {
                    key = keyIterator.next();
                    for (JaxRsMonitorFilter filter : instances) {
                        filter.jaxRsCountByName.remove(key);
                    }
                }
            }
            appMetricInfos.remove(appName);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        StatsContext.init();
        RestMetricInfo.init();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class StatsContext {
        final RestMonitorKeyCache.MonitorKey monitorKey;
        final long startTime;
        static final long serialVersionUID = 4517113110703395483L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        static void init() {
        }

        StatsContext(RestMonitorKeyCache.MonitorKey monitorKey, long startTime) {
            this.monitorKey = monitorKey;
            this.startTime = startTime;
        }

        public String toString() {
            return "StatsContext [monitorKey=" + this.monitorKey + ", startTime=" + this.startTime + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs.monitor.JaxRsMonitorFilter$StatsContext", StatsContext.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class RestMetricInfo {
        boolean isEar = false;
        HashSet<String> keys = new HashSet();
        static final long serialVersionUID = 7454957503068546259L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RestMetricInfo() {
        }

        static void init() {
        }

        void setIsEar() {
            this.isEar = true;
        }

        void setKey(String key) {
            this.keys.add(key);
        }

        HashSet<String> getKeys() {
            return this.keys;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs.monitor.JaxRsMonitorFilter$RestMetricInfo", RestMetricInfo.class, null, null);
        }
    }
}

