/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.websphere.cache.PreInvalidationListener;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.intf.CacheStatisticsListener;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.intf.DCacheConfig;
import com.ibm.ws.cache.stat.CachePerf;
import com.ibm.ws.cache.stat.CachePerfFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.EventSource;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DCacheBase
implements DCache {
    private static TraceComponent tc = Tr.register(DCacheBase.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final String DEFAULT_CACHE_NAME = "baseCache";
    public static final int DEFAULT_CACHE_SIZE = 2000;
    public static final String DEFAULT_DISTRIBUTED_MAP_NAME = "default";
    public static final String DEFAULT_BASE_JNDI_NAME = "services/cache/basecache";
    public static final String DEFAULT_DMAP_JNDI_NAME = "services/cache/distributedmap";
    public static final boolean FIRE_INVALIDATION_LISTENER = true;
    public static final boolean COORDINATE = true;
    public static final boolean INCREMENT_REFF_COUNT = true;
    public static final boolean IGNORE_COUNTING = true;
    public static final boolean ASK_PERMISSION = true;
    public static final boolean FROM_DEPID_TEMPLATE_INVALIDATION = true;
    public static final boolean CHECK_PREINVALIDATION_LISTENER = true;
    public static final boolean ENTRY_OVERWRITTEN_ON_DISK = true;
    protected String cacheName;
    protected CacheConfig cacheConfig = null;
    protected final AtomicReference<CachePerf> cachePerfRef = new AtomicReference();
    protected CacheStatisticsListener cacheStatisticsListener = null;
    protected boolean hasPushPullEntries = false;
    protected boolean memoryCacheSizeInMBEnabled = false;
    protected long upperLimitMemoryCacheSizeInBytes = -1L;
    protected long lowerLimitMemoryCacheSizeInBytes = -1L;
    protected long maxMemoryCacheSizeInBytes = -1L;
    protected volatile long currentMemoryCacheSizeInBytes = -1L;
    protected boolean bEnableListener = false;
    protected EventSource eventSource = null;
    protected boolean ignoreValueInInvalidationEvent = false;
    protected boolean swapToDisk = false;

    public DCacheBase(String cacheName, CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
        this.ignoreValueInInvalidationEvent = cacheConfig.ignoreValueInInvalidationEvent;
        this.cacheName = cacheName;
        if (cacheConfig.memoryCacheSizeInMB != -1) {
            if (cacheConfig.isDefaultCacheProvider()) {
                boolean bl = this.memoryCacheSizeInMBEnabled = cacheConfig.memoryCacheSizeInMB > 0;
                if (this.memoryCacheSizeInMBEnabled) {
                    this.currentMemoryCacheSizeInBytes = 0L;
                    this.maxMemoryCacheSizeInBytes = (long)cacheConfig.memoryCacheSizeInMB * 0x100000L;
                    this.upperLimitMemoryCacheSizeInBytes = this.maxMemoryCacheSizeInBytes * (long)cacheConfig.memoryCacheHighThreshold / 100L;
                    this.lowerLimitMemoryCacheSizeInBytes = this.maxMemoryCacheSizeInBytes * (long)cacheConfig.memoryCacheLowThreshold / 100L;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DCacheBase cacheName=" + this.cacheName + " memoryCacheSizeInMBEnabled=" + this.memoryCacheSizeInMBEnabled + " upperLimitMemoryCacheSizeInBytes=" + this.upperLimitMemoryCacheSizeInBytes + " lowerLimitMemoryCacheSizeInBytes=" + this.lowerLimitMemoryCacheSizeInBytes + " maxMemoryCacheSizeInBytes=" + this.maxMemoryCacheSizeInBytes), (Object[])new Object[0]);
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"DYNA1068E", (Object[])new Object[]{cacheConfig.cacheProviderName, this.cacheName});
                this.disableCacheSizeInMB();
            }
        }
    }

    @Override
    public synchronized boolean addChangeListener(ChangeListener listener) {
        if (this.bEnableListener && listener != null) {
            this.eventSource.addListener(listener);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addChangeListener() cacheName=" + this.cacheName + " listener=" + this.eventSource.getChangeListenerCount()), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean addInvalidationListener(InvalidationListener listener) {
        if (this.bEnableListener && listener != null) {
            this.eventSource.addListener(listener);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addInvalidationListener() cacheName=" + this.cacheName + " listener=" + this.eventSource.getInvalidationListenerCount()), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean addPreInvalidationListener(PreInvalidationListener listener) {
        if (this.bEnableListener && listener != null) {
            if (this.eventSource.getPreInvalidationListenerCount() > 0 && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addPreInvalidationListener() cacheName=" + this.cacheName + " one already exists. Overwriting old listener."), (Object[])new Object[0]);
            }
            this.eventSource.addListener(listener);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        boolean waitOnInvalidation = true;
        this.clear(waitOnInvalidation);
    }

    @Override
    public abstract void clear(boolean var1);

    @Override
    public synchronized boolean enableListener(boolean enable) {
        boolean success = true;
        if (enable && this.eventSource == null) {
            success = this.initEventSource();
        }
        this.bEnableListener = enable;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("enableListener() cacheName=" + this.cacheName + " enable=" + enable + " success=" + success + " ignoreValueInInvalidationEvent=" + this.ignoreValueInInvalidationEvent), (Object[])new Object[0]);
        }
        return success;
    }

    @Override
    @Trivial
    public DCacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    @Override
    public abstract Set getCacheIdsByDependency(Object var1);

    @Override
    public Set getCacheIdsByDependency(String dependency) {
        return this.getCacheIdsByDependency((Object)dependency);
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public CachePerf getCachePerf() {
        return this.cachePerfRef.get();
    }

    @Override
    public void setCachePerf(CachePerfFactory factory) {
        CachePerf oldPerf = this.cachePerfRef.get();
        CachePerf newPerf = null;
        if (factory != null) {
            newPerf = factory.create(this);
        }
        if (this.cachePerfRef.compareAndSet(oldPerf, newPerf) && oldPerf != null) {
            oldPerf.removePMICounters();
        }
    }

    @Override
    public CacheStatisticsListener getCacheStatisticsListener() {
        return this.cacheStatisticsListener;
    }

    @Override
    public int getDefaultPriority() {
        return this.cacheConfig.getCachePriority();
    }

    @Override
    @Trivial
    public boolean isCacheSizeInMBEnabled() {
        return this.memoryCacheSizeInMBEnabled;
    }

    @Override
    public void disableCacheSizeInMB() {
        this.memoryCacheSizeInMBEnabled = false;
        this.cacheConfig.memoryCacheSizeInMB = -1;
        this.currentMemoryCacheSizeInBytes = -1L;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("disableCacheSizeInMB() cacheName=" + this.cacheName), (Object[])new Object[0]);
        }
    }

    @Override
    public void increaseCacheSizeInBytes(long size, String msg) {
        if (this.memoryCacheSizeInMBEnabled) {
            this.currentMemoryCacheSizeInBytes += size;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("increaseCacheSizeInBytes() cacheName=" + this.cacheName + " " + msg + " size=" + size + " currentMemoryCacheSizeInBytes=" + this.currentMemoryCacheSizeInBytes), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void decreaseCacheSizeInBytes(long size, String msg) {
        if (this.memoryCacheSizeInMBEnabled) {
            this.currentMemoryCacheSizeInBytes -= size;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("decreaseCacheSizeInBytes() cacheName=" + this.cacheName + " " + msg + " size=" + size + " currentMemoryCacheSizeInBytes=" + this.currentMemoryCacheSizeInBytes), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public float getCurrentMemoryCacheSizeInMB() {
        long memoryCacheSizeInBytes = this.currentMemoryCacheSizeInBytes;
        if (memoryCacheSizeInBytes >= 0L) {
            float currentMemoryCacheSizeInMB = (float)memoryCacheSizeInBytes / 1048576.0f;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getCurrentMemoryCacheSizeInMB() cacheName=" + this.cacheName + " currentMemoryCacheSizeInBytes=" + memoryCacheSizeInBytes + " currentMemoryCacheSizeInMB=" + currentMemoryCacheSizeInMB), (Object[])new Object[0]);
            }
            return currentMemoryCacheSizeInMB;
        }
        return -1.0f;
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo ei) {
        return this.getEntry(ei, true);
    }

    @Override
    public abstract com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo var1, boolean var2);

    @Override
    public abstract com.ibm.websphere.cache.CacheEntry getEntry(Object var1, int var2, boolean var3, boolean var4);

    @Override
    public com.ibm.websphere.cache.CacheEntry getEntry(String id) {
        return this.getEntry((Object)id);
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry getEntry(Object id) {
        return this.getEntry(id, 5, true, false);
    }

    @Override
    public EventSource getEventSource() {
        return this.eventSource;
    }

    @Override
    public int getMaxNumberCacheEntries() {
        return this.cacheConfig.cacheSize;
    }

    @Override
    public boolean getSwapToDisk() {
        return this.swapToDisk;
    }

    @Override
    public Object getValue(com.ibm.websphere.cache.EntryInfo ei, boolean askPermission) {
        return this.getValue(ei.getIdObject(), ei.getTemplate(), askPermission, false);
    }

    @Override
    public Object getValue(Object id, boolean askPermission) {
        return this.getValue(id, null, askPermission, false);
    }

    @Override
    public abstract Object getValue(Object var1, String var2, boolean var3, boolean var4);

    @Override
    public Object getValue(String id, boolean askPermission) {
        return this.getValue((Object)id, askPermission);
    }

    @Override
    public boolean hasPushPullEntries() {
        return this.hasPushPullEntries;
    }

    private boolean initEventSource() {
        boolean success = false;
        try {
            this.eventSource = ServerCache.cacheUnit.createEventSource(this.cacheConfig.useListenerContext, this.cacheName);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.Cache.initEventSource", (String)"3289", (Object)this);
        }
        if (this.eventSource != null) {
            success = true;
        }
        return success;
    }

    @Override
    public void invalidateById(Object id, boolean waitOnInvalidation) {
        this.invalidateById(id, 1, waitOnInvalidation, true);
    }

    @Override
    public void invalidateById(Object id, boolean waitOnInvalidation, boolean checkPreInvalidationListener) {
        this.invalidateById(id, 1, waitOnInvalidation, checkPreInvalidationListener);
    }

    @Override
    public void invalidateById(Object id, int causeOfInvalidation, boolean waitOnInvalidation) {
        this.invalidateById(id, causeOfInvalidation, waitOnInvalidation, true);
    }

    @Override
    public abstract void invalidateById(Object var1, int var2, boolean var3, boolean var4);

    @Override
    public void invalidateById(String id, boolean waitOnInvalidation) {
        this.invalidateById(id, 1, waitOnInvalidation, true);
    }

    @Override
    public void invalidateById(Object id, int causeOfInvalidation, int sourceOfInvalidation, boolean waitOnInvalidation, boolean invokeInternalInvalidateById) {
        this.invalidateById(id, causeOfInvalidation, sourceOfInvalidation, waitOnInvalidation, invokeInternalInvalidateById, true);
    }

    @Override
    public abstract void invalidateById(Object var1, int var2, int var3, boolean var4, boolean var5, boolean var6);

    @Override
    public boolean isEnableListener() {
        return this.bEnableListener;
    }

    @Override
    public synchronized boolean removeChangeListener(ChangeListener listener) {
        if (this.bEnableListener && listener != null) {
            this.eventSource.removeListener(listener);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeInvalidationListener(InvalidationListener listener) {
        if (this.bEnableListener && listener != null) {
            this.eventSource.removeListener(listener);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removePreInvalidationListener(PreInvalidationListener listener) {
        if (this.bEnableListener && listener != null) {
            this.eventSource.removeListener(listener);
            return true;
        }
        return false;
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry setEntry(CacheEntry cacheEntry) {
        return this.setEntry(cacheEntry, 5);
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry setEntry(CacheEntry cacheEntry, int source) {
        return this.setEntry(cacheEntry, source, false, false, false);
    }

    @Override
    public abstract com.ibm.websphere.cache.CacheEntry setEntry(CacheEntry var1, int var2, boolean var3, boolean var4, boolean var5);

    @Override
    public void setValue(EntryInfo entryInfo, Object value) {
        this.setValue(entryInfo, value, !this.shouldPull(entryInfo.getSharingPolicy(), entryInfo.id), false);
    }

    @Override
    public void setValue(EntryInfo entryInfo, Object value, boolean directive) {
        this.setValue(entryInfo, value, !this.shouldPull(entryInfo.getSharingPolicy(), entryInfo.id), directive);
    }

    @Override
    public abstract void setValue(EntryInfo var1, Object var2, boolean var3, boolean var4);

    @Override
    public abstract boolean shouldPull(int var1, Object var2);
}

