/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.osgi.locator;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.osgi.ProviderLocator;
import org.apache.yoko.osgi.ProviderRegistry;
import org.apache.yoko.osgi.locator.BundleProviderLoader;
import org.apache.yoko.osgi.locator.PackageProvider;
import org.apache.yoko.osgi.locator.Register;
import org.apache.yoko.osgi.locator.ServiceProvider;

public class ProviderRegistryImpl
implements ProviderRegistry,
Register {
    private static final Logger log = Logger.getLogger(ProviderRegistryImpl.class.getName());
    private final SPIRegistry providers = new SPIRegistry();
    private final SPIRegistry serviceProviders = new SPIRegistry();
    private final ConcurrentHashMap<String, PackageProvider> packageProviders = new ConcurrentHashMap();
    private final Set<ClassLoader> knownLoaders = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    public void start() {
        ProviderLocator.setRegistry(this);
    }

    public void stop() {
        ProviderLocator.setRegistry(null);
    }

    @Override
    public void registerProvider(ServiceProvider provider) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "registering provider " + provider);
        }
        this.providers.register(provider);
    }

    @Override
    public void unregisterProvider(ServiceProvider provider) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "unregistering provider " + provider);
        }
        this.providers.unregister(provider);
    }

    @Override
    public void registerService(ServiceProvider provider) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "registering service " + provider);
        }
        this.serviceProviders.register(provider);
    }

    @Override
    public void unregisterService(ServiceProvider provider) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "unregistering service " + provider);
        }
        this.serviceProviders.unregister(provider);
    }

    @Override
    public void registerPackages(PackageProvider provider) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("registering package provider: " + provider);
        }
        for (String name : provider.getRegisteredPackageNames()) {
            PackageProvider oldProvider = this.packageProviders.put(name, provider);
            if (oldProvider == null) continue;
            log.warning(String.format("Replaced provider for package %s: was %s, but now %s", name, oldProvider, provider));
        }
    }

    @Override
    public void unregisterPackages(PackageProvider provider) {
        for (String name : provider.getRegisteredPackageNames()) {
            this.packageProviders.remove(name, provider);
        }
    }

    @Override
    public <T> Class<T> locate(String providerId) {
        return this.loadFromServiceProvider(providerId).map(Optional::of).orElseGet(() -> this.loadFromPackageProvider(providerId)).map(this::recordClass).orElse(null);
    }

    private <T> Optional<Class<T>> loadFromServiceProvider(String providerId) {
        return Optional.of(providerId).map(x$0 -> this.providers.getProvider(x$0)).map(l -> {
            try {
                return l.getServiceClass();
            }
            catch (ClassNotFoundException cnfe) {
                throw (Error)new NoClassDefFoundError().initCause(cnfe);
            }
        });
    }

    private <T> Optional<Class<T>> loadFromPackageProvider(String providerId) {
        return Optional.of(providerId).map(PackageProvider::packageName).map(this.packageProviders::get).map(provider -> provider.loadClass(providerId));
    }

    @Override
    public <T> T getService(String providerId) {
        ServiceProvider loader = this.serviceProviders.getProvider(providerId);
        if (loader != null) {
            try {
                return this.recordInstance(loader.getServiceInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Error trying to load service of type " + loader.getClassName(), e);
            }
        }
        return null;
    }

    @Override
    public <T> Class<T> getServiceClass(String providerId) {
        ServiceProvider sp = this.serviceProviders.getProvider(providerId);
        if (sp != null) {
            try {
                return this.recordClass(sp.getServiceClass());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error locating service class: " + sp.getClassName(), e);
            }
        }
        return null;
    }

    private <T> T recordInstance(T t) {
        Optional.ofNullable(t).map(Object::getClass).map(this::recordClass);
        return t;
    }

    private <T> Class<T> recordClass(Class<T> cls) {
        Optional.ofNullable(cls).map(c -> ProviderRegistryImpl.doPriv(c::getClassLoader)).map(this::recordLoader);
        return cls;
    }

    private ClassLoader recordLoader(ClassLoader loader) {
        Optional.ofNullable(loader).map(this.knownLoaders::add);
        return loader;
    }

    @Override
    public boolean isServiceClassLoader(ClassLoader loader) {
        return this.knownLoaders.contains(loader);
    }

    @Override
    @Deprecated
    public void registerProvider(BundleProviderLoader bundleProviderLoader) {
        this.registerProvider(bundleProviderLoader.wrapAsServiceProvider());
    }

    @Override
    @Deprecated
    public void unregisterProvider(BundleProviderLoader bundleProviderLoader) {
        this.unregisterProvider(bundleProviderLoader.wrapAsServiceProvider());
    }

    @Override
    @Deprecated
    public void registerService(BundleProviderLoader bundleProviderLoader) {
        this.registerService(bundleProviderLoader.wrapAsServiceProvider());
    }

    @Override
    @Deprecated
    public void unregisterService(BundleProviderLoader bundleProviderLoader) {
        this.unregisterService(bundleProviderLoader.wrapAsServiceProvider());
    }

    private static <T> T doPriv(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    private static class SPIRegistry {
        private final Map<String, Queue<ServiceProvider>> registry = new HashMap<String, Queue<ServiceProvider>>();

        private SPIRegistry() {
        }

        synchronized void register(ServiceProvider provider) {
            String providerId = provider.getId();
            Queue<ServiceProvider> q = this.registry.get(providerId);
            if (q == null) {
                q = new PriorityQueue<ServiceProvider>(2);
                this.registry.put(providerId, q);
            }
            q.add(provider);
        }

        synchronized void unregister(ServiceProvider provider) {
            Queue<ServiceProvider> q = this.registry.get(provider.getId());
            if (q != null) {
                q.remove(provider);
            }
        }

        private synchronized ServiceProvider getProvider(String id) {
            Queue<ServiceProvider> q;
            if (log.isLoggable(Level.FINE)) {
                log.fine("registry: " + this.registry);
            }
            if ((q = this.registry.get(id)) == null || q.isEmpty()) {
                return null;
            }
            return q.peek();
        }
    }
}

