/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.FileRangeException;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.plugins.server.Cleanable;
import org.jboss.resteasy.plugins.server.Cleanables;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.util.NoContent;

public abstract class AbstractDiskIoProvider<T>
implements MessageBodyReader<T>,
AsyncMessageBodyWriter<T> {
    private static final String PREFIX = "pfx";
    private static final String SUFFIX = "sfx";

    protected Path readFromStream(MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        Path downloadedFile = Files.createTempFile(PREFIX, SUFFIX, new FileAttribute[0]);
        Cleanables cleanables = ResteasyContext.getContextData(Cleanables.class);
        if (cleanables != null) {
            cleanables.addCleanable(new PathHolder(downloadedFile));
        } else {
            LogMessages.LOGGER.temporaryFileCreated(downloadedFile.toString());
        }
        if (NoContent.isContentLengthZero(httpHeaders)) {
            return downloadedFile;
        }
        try (OutputStream output = Files.newOutputStream(downloadedFile, new OpenOption[0]);){
            ProviderHelper.writeTo(entityStream, output);
        }
        return downloadedFile;
    }

    protected void writeToStream(Path uploadFile, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        HttpHeaders headers = ResteasyContext.getContextData(HttpHeaders.class);
        if (headers == null) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        String range = (String)headers.getRequestHeaders().getFirst((Object)"Range");
        if (range == null) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        int byteUnit = (range = range.trim()).indexOf("bytes=");
        if (byteUnit < 0) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        if ((range = range.substring("bytes=".length())).indexOf(44) > -1) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        int separator = range.indexOf(45);
        if (separator < 0) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        if (separator == 0) {
            long begin;
            long fileSize = this.getPathSize(uploadFile);
            if (fileSize + (begin = Long.parseLong(range)) < 1L) {
                this.writeIt(uploadFile, entityStream);
                return;
            }
            throw new FileRangeException(mediaType, uploadFile.toFile(), fileSize + begin, fileSize - 1L);
        }
        try {
            throw this.buildFileRangeException(uploadFile, mediaType, range, separator);
        }
        catch (NumberFormatException e) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
    }

    protected CompletionStage<Void> asyncWriteToStream(Path uploadFile, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        HttpHeaders headers = ResteasyContext.getContextData(HttpHeaders.class);
        if (headers == null) {
            return this.writeIt(uploadFile, entityStream);
        }
        String range = (String)headers.getRequestHeaders().getFirst((Object)"Range");
        if (range == null) {
            return this.writeIt(uploadFile, entityStream);
        }
        int byteUnit = (range = range.trim()).indexOf("bytes=");
        if (byteUnit < 0) {
            return this.writeIt(uploadFile, entityStream);
        }
        if ((range = range.substring("bytes=".length())).indexOf(44) > -1) {
            return this.writeIt(uploadFile, entityStream);
        }
        int separator = range.indexOf(45);
        if (separator < 0) {
            return this.writeIt(uploadFile, entityStream);
        }
        if (separator == 0) {
            long begin;
            long fileSize = this.getPathSize(uploadFile);
            if (fileSize + (begin = Long.parseLong(range)) < 1L) {
                return this.writeIt(uploadFile, entityStream);
            }
            return ProviderHelper.completedException((Throwable)((Object)new FileRangeException(mediaType, uploadFile.toFile(), fileSize + begin, fileSize - 1L)));
        }
        try {
            return ProviderHelper.completedException((Throwable)((Object)this.buildFileRangeException(uploadFile, mediaType, range, separator)));
        }
        catch (NumberFormatException e) {
            return this.writeIt(uploadFile, entityStream);
        }
    }

    protected void writeIt(Path uploadFile, OutputStream entityStream) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(uploadFile, new OpenOption[0]));){
            ProviderHelper.writeTo((InputStream)inputStream, entityStream);
        }
    }

    protected CompletionStage<Void> writeIt(Path uploadFile, AsyncOutputStream entityStream) {
        try {
            BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(uploadFile, new OpenOption[0]));
            return ProviderHelper.writeToAndCloseInput(inputStream, entityStream);
        }
        catch (IOException e) {
            return ProviderHelper.completedException(e);
        }
    }

    private FileRangeException buildFileRangeException(Path uploadFile, MediaType mediaType, String range, int separator) {
        long end;
        long fileSize = this.getPathSize(uploadFile);
        long begin = Long.parseLong(range.substring(0, separator));
        if (begin >= fileSize) {
            throw new WebApplicationException(416);
        }
        if (range.endsWith("-")) {
            end = fileSize - 1L;
        } else {
            String substring = range.substring(separator + 1);
            end = Long.parseLong(substring);
        }
        return new FileRangeException(mediaType, uploadFile.toFile(), begin, end);
    }

    protected long getPathSize(Path uploadFile) {
        try {
            return Files.size(uploadFile);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private record PathHolder(Path file) implements Cleanable
    {
        @Override
        public void clean() throws Exception {
            Files.deleteIfExists(this.file);
        }
    }
}

