/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec.identitystore.permissions;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.security.enterprise.identitystore.IdentityStorePermission;
import java.security.Permission;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class IdentityStorePermissionService {
    private static final TraceComponent tc = Tr.register(IdentityStorePermissionService.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
    static final long serialVersionUID = 4684362822324627196L;

    public static void checkPermission(String name) {
        SecurityManager securityManager;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Using Jakarta Security 1.0/2.0/3.0 implementation.", (Object[])new Object[0]);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)new IdentityStorePermission(name));
        }
    }

    public static void checkPermission(String name, String action) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)new IdentityStorePermission(name, action));
        }
    }
}

