/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class OSGiBeanLocator
implements ConfiguredBeanLocator {
    private static final Logger LOG = LogUtils.getL7dLogger(OSGiBeanLocator.class);
    private static final String COMPATIBLE_LOCATOR_PROP = "org.apache.cxf.bus.osgi.locator";
    private static final String COMPATIBLE_LOCATOR_PROP_CHECK = "org.apache.cxf.bus.osgi.locator.check";
    final ConfiguredBeanLocator cbl;
    final BundleContext context;
    private boolean checkCompatibleLocators;
    static final long serialVersionUID = -6011795676669443102L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public OSGiBeanLocator(ConfiguredBeanLocator c, BundleContext ctx) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.OSGiBeanLocator", "<init>", new Object[]{c, ctx});
        }
        this.cbl = c;
        this.context = ctx;
        Object checkProp = null;
        if (System.getSecurityManager() != null) {
            try {
                checkProp = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = -5952830898536881423L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object run() {
                        return OSGiBeanLocator.this.context.getProperty(OSGiBeanLocator.COMPATIBLE_LOCATOR_PROP_CHECK);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.bus.osgi.OSGiBeanLocator$1", 1.class, null, null);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {}
        } else {
            checkProp = this.context.getProperty(COMPATIBLE_LOCATOR_PROP_CHECK);
        }
        boolean bl = this.checkCompatibleLocators = checkProp == null || PropertyUtils.isTrue(checkProp);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.OSGiBeanLocator", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> T getBeanOfType(String name, Class<T> type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.OSGiBeanLocator", "getBeanOfType", new Object[]{name, type});
        }
        T t = this.cbl.getBeanOfType(name, type);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.bus.osgi.OSGiBeanLocator", "getBeanOfType", t);
        }
        return t;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> Collection<? extends T> getBeansOfType(Class<T> type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.OSGiBeanLocator", "getBeansOfType", new Object[]{type});
        }
        Collection<T> ret = this.cbl.getBeansOfType(type);
        if (ret == null || ret.isEmpty()) {
            List<T> list = this.getBeansFromOsgiService(type);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.bus.osgi.OSGiBeanLocator", "getBeansOfType", list);
            }
            return list;
        }
        Collection<T> collection = ret;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            collection = collection;
            LOG.exiting("org.apache.cxf.bus.osgi.OSGiBeanLocator", "getBeansOfType", collection);
        }
        return collection;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> List<T> getBeansFromOsgiService(final Class<T> type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.OSGiBeanLocator", "getBeansFromOsgiService", new Object[]{type});
        }
        ArrayList<T> list = new ArrayList<T>();
        try {
            Object[] refs = null;
            refs = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<ServiceReference<?>[]>(){
                static final long serialVersionUID = -5007166732309525567L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ServiceReference<?>[] run() throws Exception {
                    return OSGiBeanLocator.this.context.getServiceReferences(type.getName(), null);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.bus.osgi.OSGiBeanLocator$2", 2.class, null, null);
                }
            }) : this.context.getServiceReferences(type.getName(), null);
            if (refs != null) {
                for (ServiceReference r : refs) {
                    if (type == ClassLoader.class && this.checkCompatibleLocators && !PropertyUtils.isTrue(r.getProperty(COMPATIBLE_LOCATOR_PROP))) continue;
                    list.add(type.cast(this.context.getService(r)));
                }
            }
        }
        catch (Exception ex) {
            LOG.info("Tried to find the Bean with type:" + type + " from OSGi services and get error: " + ex);
        }
        ArrayList<T> arrayList = list;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.bus.osgi.OSGiBeanLocator", "getBeansFromOsgiService", arrayList);
        }
        return arrayList;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> boolean loadBeansOfType(Class<T> type, ConfiguredBeanLocator.BeanLoaderListener<T> listener) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.OSGiBeanLocator", "loadBeansOfType", new Object[]{type, listener});
        }
        boolean bl = this.cbl.loadBeansOfType(type, listener);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.bus.osgi.OSGiBeanLocator", "loadBeansOfType", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean hasConfiguredPropertyValue(String beanName, String propertyName, String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.OSGiBeanLocator", "hasConfiguredPropertyValue", new Object[]{beanName, propertyName, value});
        }
        boolean bl = this.cbl.hasConfiguredPropertyValue(beanName, propertyName, value);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.bus.osgi.OSGiBeanLocator", "hasConfiguredPropertyValue", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getBeanNamesOfType(Class<?> type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.OSGiBeanLocator", "getBeanNamesOfType", new Object[]{type});
        }
        List<String> list = this.cbl.getBeanNamesOfType(type);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.bus.osgi.OSGiBeanLocator", "getBeanNamesOfType", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean hasBeanOfName(String name) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.OSGiBeanLocator", "hasBeanOfName", new Object[]{name});
        }
        boolean bl = this.cbl.hasBeanOfName(name);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.bus.osgi.OSGiBeanLocator", "hasBeanOfName", bl);
        }
        return bl;
    }
}

