/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.command.CommandCache;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.intf.ServletCacheUnit;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.cache.web.ExternalCacheGroup;
import com.ibm.ws.cache.web.ExternalCacheServices;
import com.ibm.ws.cache.web.command.SerializedPutCommandStorage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServletCacheUnitImpl
implements ServletCacheUnit {
    private static TraceComponent tc = Tr.register(ServletCacheUnitImpl.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private ExternalCacheServices externalCacheServices = new ExternalCacheServices();
    private Map<String, CommandCache> commandCacheInstances = new HashMap<String, CommandCache>();
    private Map<String, JSPCache> jspCacheInstances = new HashMap<String, JSPCache>();

    public void purgeState() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"purgeState", (Object[])new Object[0]);
        }
        Collection<CommandCache> commandCaches = this.commandCacheInstances.values();
        for (CommandCache cc : commandCaches) {
            ServerCache.getCacheInstances().remove(cc.getCache());
            cc.getCache().stop();
        }
        this.commandCacheInstances.clear();
        Collection<JSPCache> jspCaches = this.jspCacheInstances.values();
        for (JSPCache jspCache : jspCaches) {
            ServerCache.getCacheInstances().remove(jspCache.getCache());
            jspCache.getCache().stop();
        }
        this.jspCacheInstances.clear();
        this.externalCacheServices = new ExternalCacheServices();
    }

    public void createBaseCache() {
        CacheConfig cacheConfig;
        this.getCommandCache("baseCache");
        this.getJSPCache("baseCache");
        this.externalCacheServices.start();
        BatchUpdateDaemon batchUpdateDaemon = ServerCache.cacheUnit.getBatchUpdateDaemon();
        if (batchUpdateDaemon != null) {
            batchUpdateDaemon.setExternalCacheServices((com.ibm.ws.cache.intf.ExternalCacheServices)this.externalCacheServices);
        }
        if (null != (cacheConfig = ServerCache.getCacheService().getCacheInstanceConfig("services/cache/basecache"))) {
            HashMap externalCacheGroups = this.initializeExternalCacheGroups(cacheConfig.getExternalGroups());
            this.externalCacheServices.setExternalCacheGroups(externalCacheGroups);
        }
    }

    public com.ibm.ws.cache.intf.CommandCache getCommandCache(String cacheName) {
        CommandCache cacheOut = this.commandCacheInstances.get(cacheName);
        if (!this.commandCacheInstances.containsKey(cacheName)) {
            CacheConfig config = ServerCache.getCacheService().getCacheInstanceConfig(cacheName);
            if (config == null) {
                Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object[])new Object[]{cacheName});
                cacheOut = null;
            } else if (!config.isEnableServletSupport()) {
                Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object[])new Object[]{cacheName});
                cacheOut = null;
            } else {
                DCache cache = ServerCache.getCache((String)cacheName);
                if (cache == null) {
                    cache = ServerCache.createCache((String)cacheName, (CacheConfig)config);
                }
                cacheOut = new CommandCache();
                cacheOut.setCache(cache);
                cacheOut.setBatchUpdateDaemon(ServerCache.cacheUnit.getBatchUpdateDaemon());
                cacheOut.setRemoteServices(cache.getRemoteServices());
                cacheOut.setCommandStoragePolicy(new SerializedPutCommandStorage());
                cacheOut.start();
            }
            this.commandCacheInstances.put(cacheName, cacheOut);
            if (cacheName.equals("services/cache/basecache") || cacheName.equals("baseCache")) {
                ServerCache.commandCache = cacheOut;
            }
        }
        return cacheOut;
    }

    public com.ibm.ws.cache.intf.JSPCache getJSPCache(String cacheName) {
        JSPCache cacheOut = this.jspCacheInstances.get(cacheName);
        if (!this.jspCacheInstances.containsKey(cacheName)) {
            CacheConfig config = ServerCache.getCacheService().getCacheInstanceConfig(cacheName);
            if (config == null) {
                Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object[])new Object[]{cacheName});
                cacheOut = null;
            } else if (!config.isEnableServletSupport()) {
                Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object[])new Object[]{cacheName});
                cacheOut = null;
            } else {
                DCache cache = ServerCache.getCache((String)cacheName);
                if (cache == null) {
                    cache = ServerCache.createCache((String)cacheName, (CacheConfig)config);
                }
                cacheOut = new JSPCache();
                cacheOut.setCache(cache);
                cacheOut.setBatchUpdateDaemon(ServerCache.cacheUnit.getBatchUpdateDaemon());
                cacheOut.setRemoteServices(cache.getRemoteServices());
                cacheOut.setDefaultPriority(config.getJspCachePriority());
                cacheOut.setExternalCacheServices(this.externalCacheServices);
                cacheOut.start();
            }
            this.jspCacheInstances.put(cacheName, cacheOut);
            if (cacheName.equals("services/cache/basecache") || cacheName.equals("baseCache")) {
                ServerCache.jspCache = cacheOut;
            }
        }
        return cacheOut;
    }

    public void addExternalCacheAdapter(String groupId, String address, String beanName) {
        this.externalCacheServices.addExternalCacheAdapter(groupId, address, beanName);
    }

    public void removeExternalCacheAdapter(String groupId, String address) {
        this.externalCacheServices.removeExternalCacheAdapter(groupId, address);
    }

    public void invalidateExternalCaches(HashMap invalidateIdEvents, HashMap invalidateTemplateEvents) {
        this.externalCacheServices.invalidateExternalCaches(invalidateIdEvents, invalidateTemplateEvents);
    }

    private HashMap initializeExternalCacheGroups(List groupList) {
        HashMap<String, ExternalCacheGroup> externalCacheGroups = new HashMap<String, ExternalCacheGroup>();
        if (groupList != null) {
            for (CacheConfig.ExternalCacheGroup ecg : groupList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ecg.name=" + ecg.name + " ecg.type=" + ecg.type), (Object[])new Object[0]);
                }
                ExternalCacheGroup externalCacheGroup = new ExternalCacheGroup(ecg.name, ecg.type);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("adding External Cache Group id = " + ecg.name + ", externalCacheGroup = " + externalCacheGroup), (Object[])new Object[0]);
                }
                externalCacheGroups.put(ecg.name, externalCacheGroup);
                for (CacheConfig.ExternalCacheGroupMember ecgm : ecg.members) {
                    externalCacheGroup.addExternalCacheAdapter(ecgm.address, ecgm.beanName);
                }
            }
        }
        return externalCacheGroups;
    }

    public void purgeState(String cacheName) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("purgeState() cacheName=" + cacheName), (Object[])new Object[0]);
        }
        this.commandCacheInstances.remove(cacheName);
        this.jspCacheInstances.remove(cacheName);
    }
}

