/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.faulttolerance.cdi.AggregatedFTPolicy;
import com.ibm.ws.microprofile.faulttolerance.cdi.FTEnablementConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.FaultTolerance;
import com.ibm.ws.microprofile.faulttolerance.cdi.FaultToleranceCDIComponent;
import com.ibm.ws.microprofile.faulttolerance.cdi.FaultToleranceCDIExtension;
import com.ibm.ws.microprofile.faulttolerance.cdi.PolicyStore;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.AnnotationConfigFactory;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.AsynchronousConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.BulkheadConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.CircuitBreakerConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.FallbackConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.RetryConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.TimeoutConfig;
import com.ibm.ws.microprofile.faulttolerance.spi.AsyncRequestContextController;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.ExecutionException;
import com.ibm.ws.microprofile.faulttolerance.spi.Executor;
import com.ibm.ws.microprofile.faulttolerance.spi.FTAnnotationInspector;
import com.ibm.ws.microprofile.faulttolerance.spi.FTExecutionContext;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

@FaultTolerance
@Interceptor
@Priority(value=1000)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FaultToleranceInterceptor {
    private static final TraceComponent tc = Tr.register(FaultToleranceInterceptor.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.cdi.resources.FaultToleranceCDI");
    private static final String CONCURRENCY_ASYNC_ANNO = "jakarta.enterprise.concurrent.Asynchronous";
    @Inject
    private BeanManager beanManager;
    @Inject
    private PolicyStore policyStore;
    @Inject
    @Intercepted
    private Bean<?> bean;
    @Inject
    Instance<AsyncRequestContextController> rcInstance;
    static final long serialVersionUID = -7982150721197172727L;

    @AroundInvoke
    public Object executeFT(InvocationContext context) throws Exception {
        AggregatedFTPolicy policy = this.getFTPolicies(context);
        Object result = this.execute(context, policy);
        return result;
    }

    private AggregatedFTPolicy getFTPolicies(InvocationContext context) {
        AggregatedFTPolicy policy = null;
        Method method = context.getMethod();
        policy = this.policyStore.getOrCreate(this.bean, method, () -> this.processPolicies(context, this.beanManager));
        return policy;
    }

    private AggregatedFTPolicy processPolicies(InvocationContext context, BeanManager beanManager) {
        AsynchronousConfig asynchronous = null;
        RetryConfig retry = null;
        CircuitBreakerConfig circuitBreaker = null;
        TimeoutConfig timeout = null;
        BulkheadConfig bulkhead = null;
        FallbackConfig fallback = null;
        FTEnablementConfig enablement = FaultToleranceCDIComponent.getEnablementConfig();
        AnnotationConfigFactory annotationConfigFactory = FaultToleranceCDIExtension.getAnnotationConfigFactory();
        Class<?> targetClass = context.getTarget().getClass();
        Annotation[] annotations = this.getAnnotations(targetClass);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Processing annotations on class", (Object[])new Object[]{targetClass, annotations});
        }
        for (Annotation annotation : annotations) {
            if (!enablement.isFaultTolerance(annotation) || !enablement.isAnnotationEnabled(annotation, targetClass)) continue;
            if (annotation.annotationType().equals(Asynchronous.class)) {
                asynchronous = annotationConfigFactory.createAsynchronousConfig(targetClass, (Asynchronous)annotation);
                asynchronous.validate();
                continue;
            }
            if (annotation.annotationType().equals(Retry.class)) {
                retry = new RetryConfig(targetClass, (Retry)annotation);
                retry.validate();
                continue;
            }
            if (annotation.annotationType().equals(CircuitBreaker.class)) {
                circuitBreaker = annotationConfigFactory.createCircuitBreakerConfig(targetClass, (CircuitBreaker)annotation);
                circuitBreaker.validate();
                continue;
            }
            if (annotation.annotationType().equals(Timeout.class)) {
                timeout = new TimeoutConfig(targetClass, (Timeout)annotation);
                timeout.validate();
                continue;
            }
            if (!annotation.annotationType().equals(Bulkhead.class)) continue;
            bulkhead = new BulkheadConfig(targetClass, (Bulkhead)annotation);
            bulkhead.validate();
        }
        Method method = context.getMethod();
        annotations = method.getAnnotations();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Processing annotations on method", (Object[])new Object[]{method, annotations});
        }
        for (Annotation annotation : annotations) {
            if (!enablement.isFaultTolerance(annotation) || !enablement.isAnnotationEnabled(annotation, targetClass, method)) continue;
            if (annotation.annotationType().equals(Asynchronous.class)) {
                asynchronous = annotationConfigFactory.createAsynchronousConfig(method, targetClass, (Asynchronous)annotation);
                asynchronous.validate();
                continue;
            }
            if (annotation.annotationType().equals(Retry.class)) {
                retry = new RetryConfig(method, targetClass, (Retry)annotation);
                retry.validate();
                continue;
            }
            if (annotation.annotationType().equals(CircuitBreaker.class)) {
                circuitBreaker = annotationConfigFactory.createCircuitBreakerConfig(method, targetClass, (CircuitBreaker)annotation);
                circuitBreaker.validate();
                continue;
            }
            if (annotation.annotationType().equals(Timeout.class)) {
                timeout = new TimeoutConfig(method, targetClass, (Timeout)annotation);
                timeout.validate();
                continue;
            }
            if (annotation.annotationType().equals(Bulkhead.class)) {
                bulkhead = new BulkheadConfig(method, targetClass, (Bulkhead)annotation);
                bulkhead.validate();
                continue;
            }
            if (!annotation.annotationType().equals(Fallback.class)) continue;
            fallback = annotationConfigFactory.createFallbackConfig(method, targetClass, (Fallback)annotation);
            fallback.validate();
        }
        AggregatedFTPolicy aggregatedFTPolicy = new AggregatedFTPolicy();
        aggregatedFTPolicy.setMethod(method);
        if (asynchronous != null) {
            aggregatedFTPolicy.setAsynchronousResultWrapper(method.getReturnType());
        }
        if (timeout != null) {
            TimeoutPolicy timeoutPolicy = timeout.generatePolicy();
            aggregatedFTPolicy.setTimeoutPolicy(timeoutPolicy);
        }
        if (retry != null) {
            RetryPolicy retryPolicy = retry.generatePolicy();
            aggregatedFTPolicy.setRetryPolicy(retryPolicy);
        }
        if (circuitBreaker != null) {
            CircuitBreakerPolicy circuitBreakerPolicy = circuitBreaker.generatePolicy();
            aggregatedFTPolicy.setCircuitBreakerPolicy(circuitBreakerPolicy);
        }
        if (bulkhead != null) {
            BulkheadPolicy bulkheadPolicy = bulkhead.generatePolicy();
            aggregatedFTPolicy.setBulkheadPolicy(bulkheadPolicy);
        }
        if (fallback != null) {
            FallbackPolicy fallbackPolicy = fallback.generatePolicy(context, beanManager);
            aggregatedFTPolicy.setFallbackPolicy(fallbackPolicy);
        }
        return aggregatedFTPolicy;
    }

    private Annotation[] getAnnotations(Class<?> targetClass) {
        for (FTAnnotationInspector annotationInspector : FaultToleranceCDIComponent.getAnnotationInspectors()) {
            Annotation[] result = annotationInspector.getAnnotations(targetClass);
            if (result == null) continue;
            return result;
        }
        return targetClass.getAnnotations();
    }

    @FFDCIgnore(value={ExecutionException.class})
    private Object execute(InvocationContext invocationContext, AggregatedFTPolicy aggregatedFTPolicy) throws Exception {
        Object result = null;
        if (aggregatedFTPolicy != null) {
            aggregatedFTPolicy.setRequestContextInstance(this.rcInstance);
            Executor<Object> executor = aggregatedFTPolicy.getExecutor();
            Method method = invocationContext.getMethod();
            for (Annotation anno : method.getAnnotations()) {
                if (!CONCURRENCY_ASYNC_ANNO.equals(anno.annotationType().getName())) continue;
                throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"anno.conflict.CWMFT5022E", (Object[])new Object[]{CONCURRENCY_ASYNC_ANNO}));
            }
            Object[] params = invocationContext.getParameters();
            FTExecutionContext executionContext = executor.newExecutionContext(this.generateId(method), method, params);
            Callable<Object> callable = () -> invocationContext.proceed();
            try {
                result = executor.execute(callable, (ExecutionContext)executionContext);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw e;
            }
        } else {
            result = invocationContext.proceed();
        }
        return result;
    }

    @Trivial
    private String generateId(Method method) {
        int rand = ThreadLocalRandom.current().nextInt();
        return method.getName() + "-" + Integer.toHexString(rand);
    }
}

