/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.netty;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.framework.IOReadCompletedCallback;
import com.ibm.ws.sib.jfapchannel.framework.IOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.NettyConnectionReadCompletedCallback;
import com.ibm.ws.sib.jfapchannel.netty.NettyIOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnection;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnectionFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.openliberty.netty.internal.exception.NettyException;

public class NettyJMSClientHandler
extends SimpleChannelInboundHandler<WsByteBuffer> {
    private static final TraceComponent tc = SibTr.register(NettyJMSClientHandler.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    protected static final AttributeKey<String> CHAIN_ATTR_KEY;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)("channelActive: connected for chain " + (String)ctx.channel().attr(CHAIN_ATTR_KEY).get()), (Object)ctx.channel());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"channelActive", (Object)ctx.channel());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void channelRead0(ChannelHandlerContext ctx, WsByteBuffer msg) throws Exception {
        block7: {
            Attribute attr;
            Connection connection;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"channelRead0", (Object)ctx.channel());
            }
            if ((connection = (Connection)(attr = ctx.channel().attr(NettyNetworkConnectionFactory.CONNECTION)).get()) != null) {
                IOReadCompletedCallback callback = connection.getReadCompletedCallback();
                IOReadRequestContext readCtx = connection.getReadRequestContext();
                NetworkConnection networkConnection = connection.getNetworkConnection();
                if (callback instanceof NettyConnectionReadCompletedCallback && readCtx instanceof NettyIOReadRequestContext && networkConnection instanceof NettyNetworkConnection) {
                    ((NettyConnectionReadCompletedCallback)callback).readCompleted(msg, readCtx, (NettyNetworkConnection)networkConnection);
                    break block7;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                        SibTr.warning((TraceComponent)tc, (String)"channelRead0: Something's wrong. Callback, network connection, or read context is not netty specific. This shouldn't happen.", (Object)new Object[]{connection, callback, readCtx, networkConnection});
                    }
                    this.exceptionCaught(ctx, new NettyException("Illegal callback type for channel."));
                    return;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.warning((TraceComponent)tc, (String)"channelRead0: could not associate an incoming message with a Connection. Message will be ignored and channel will be closed.", (Object)new Object[]{ctx.channel()});
                ctx.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"channelRead0", (Object)ctx.channel());
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"channelInactive", (Object)ctx.channel());
        }
        Connection connection = (Connection)ctx.channel().attr(NettyNetworkConnectionFactory.CONNECTION).get();
        if (tc.isEntryEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Fired for connection which is closed?: " + connection.isClosed() + " closedDeffered?: " + connection.isCloseDeferred()), (Object)new Object[]{ctx.channel(), connection});
        }
        ctx.channel().attr(NettyNetworkConnectionFactory.CONNECTION).set(null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"channelInactive", (Object)ctx.channel());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Attribute attr;
        Connection connection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"exceptionCaught", (Object)new Object[]{ctx.channel(), cause});
        }
        if ((connection = (Connection)(attr = ctx.channel().attr(NettyNetworkConnectionFactory.CONNECTION)).get()) == null) {
            if (tc.isEntryEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Found null connection for JMS Channel. Closing channel and moving cause through pipeline.", (Object)ctx.channel());
            }
            ctx.close();
        } else {
            connection.invalidate(false, cause, "Connection closed due to exception");
            ctx.channel().attr(NettyNetworkConnectionFactory.CONNECTION).set(null);
            ctx.close();
        }
        super.exceptionCaught(ctx, cause);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"exceptionCaught", (Object)ctx.channel());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/netty/jfapchannel/NettyJMSClientHandler.java, SIB.comms, WASX.SIB, uu1215.01 1.1");
        }
        CHAIN_ATTR_KEY = AttributeKey.valueOf((String)"CHAIN_NAME");
    }
}

