/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.BaseSIXAResourceProxy;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIXAResource;
import java.util.ArrayList;
import java.util.HashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SuspendableXAResource
extends Transaction
implements SIXAResource {
    private static String CLASS_NAME = SuspendableXAResource.class.getName();
    private static final TraceComponent tc = SibTr.register(SuspendableXAResource.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private HashMap<Xid, BaseSIXAResourceProxy> suspendedTransactions = new HashMap();
    private BaseSIXAResourceProxy currentLiveXAResource = null;
    private ArrayList<BaseSIXAResourceProxy> useableXAResources = new ArrayList();
    private Xid currentXid = null;
    private boolean useMSResource = false;

    public SuspendableXAResource(Conversation con, ConnectionProxy owningConnection, BaseSIXAResourceProxy initialXAResource, boolean useMSResource) {
        super(con, owningConnection);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{con, owningConnection, initialXAResource, "" + useMSResource});
        }
        this.currentLiveXAResource = initialXAResource;
        this.useMSResource = useMSResource;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public SIXAResource getCurrentXAResource() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCurrentXAResource");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCurrentXAResource", (Object)this.currentLiveXAResource);
        }
        return this.currentLiveXAResource;
    }

    @Override
    public boolean isValid() {
        return this.currentLiveXAResource.isValid();
    }

    @Override
    public int getTransactionId() {
        return this.currentLiveXAResource.getTransactionId();
    }

    public void start(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)new Object[]{xid, flags});
        }
        if ((flags & 0x8000000) != 0) {
            BaseSIXAResourceProxy tx;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"TMRESUME was specified");
            }
            if ((tx = this.suspendedTransactions.remove(xid)) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"There was no XId in the map");
                }
                throw new XAException(-4);
            }
            this.currentLiveXAResource = tx;
            this.currentLiveXAResource.isSuspended = false;
            this.currentLiveXAResource.setEnlisted(xid);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Resumed: ", (Object)this.currentLiveXAResource);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Starting a new transaction");
            }
            if (this.currentLiveXAResource != null && !this.currentLiveXAResource.isSuspended) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using the current XAResource");
                }
            } else if (this.useableXAResources.size() != 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Re-using an old SIXAResource");
                }
                this.currentLiveXAResource = this.useableXAResources.remove(0);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Obtaining fresh XA Resource");
                }
                try {
                    this.currentLiveXAResource = this.getConnectionProxy()._createXAResource(this.useMSResource);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".start"), (String)"1-016-0001", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to obtain the XA Resource");
                    }
                    XAException xa = new XAException(-3);
                    xa.initCause(e);
                    throw xa;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using: ", (Object)this.currentLiveXAResource);
            }
            this.currentLiveXAResource.start(xid, flags);
        }
        this.currentXid = xid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"end", (Object)new Object[]{xid, flags});
        }
        if ((flags & 0x2000000) != 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"TMSUSPEND was specified");
            }
            if (this.suspendedTransactions.get(xid) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"XID is already suspended");
                }
                throw new XAException(-6);
            }
            if (this.currentXid != null && !this.currentXid.equals(xid)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Attempt to suspend some other XId");
                }
                throw new XAException(-4);
            }
            this.suspendedTransactions.put(xid, this.currentLiveXAResource);
            this.currentLiveXAResource.isSuspended = true;
            this.currentLiveXAResource.setEnlisted(null);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"TMSUSPEND was not specified");
            }
            if (!this.currentLiveXAResource.isEnlisted()) {
                BaseSIXAResourceProxy tx;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Currently not enlisted");
                }
                if ((tx = this.suspendedTransactions.remove(xid)) == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"No suspended XId found and not currently started");
                    }
                    throw new XAException(-4);
                }
                this.currentLiveXAResource = tx;
                this.currentLiveXAResource.setEnlisted(xid);
            }
            this.currentLiveXAResource.isSuspended = false;
            this.currentLiveXAResource.end(xid, flags);
            if (!this.useableXAResources.contains(this.currentLiveXAResource)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Pooling the SIXAResource");
                }
                this.useableXAResources.add(this.currentLiveXAResource);
            }
        }
        this.currentXid = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"end");
        }
    }

    public void forget(Xid xid) throws XAException {
        this.currentLiveXAResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.currentLiveXAResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isSameRM", (Object)xares);
        }
        XAResource actualXARes = xares;
        if (xares instanceof SuspendableXAResource) {
            actualXARes = ((SuspendableXAResource)((Object)xares)).getCurrentXAResource();
        }
        boolean result = this.currentLiveXAResource.isSameRM(actualXARes);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isSameRM", (Object)result);
        }
        return result;
    }

    public int prepare(Xid xid) throws XAException {
        return this.currentLiveXAResource.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.currentLiveXAResource.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this.currentLiveXAResource.rollback(xid);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.currentLiveXAResource.setTransactionTimeout(seconds);
    }

    public boolean isEnlisted() {
        return this.currentLiveXAResource.isEnlisted();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.currentLiveXAResource.commit(xid, onePhase);
    }
}

