/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.ra.SibRaEngineComponent;
import com.ibm.ws.sib.ra.SibRaMessagingEngineListener;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaResourceAdapterImpl;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationAvailability;
import com.ibm.wsspi.sib.core.DestinationListener;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.util.Map;

final class SibRaDynamicDestinationEndpointActivation
extends SibRaEndpointActivation {
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaDynamicDestinationEndpointActivation.class);
    private static final TraceComponent LISTENER_TRACE = SibRaUtils.getTraceComponent(SibRaDestinationListener.class);
    private static final String CLASS_NAME = SibRaDynamicDestinationEndpointActivation.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";

    SibRaDynamicDestinationEndpointActivation(SibRaResourceAdapterImpl resourceAdapter, MessageEndpointFactory messageEndpointFactory, SibRaEndpointConfiguration endpointConfiguration, SibRaEndpointInvoker endpointInvoker) throws ResourceException {
        super(resourceAdapter, messageEndpointFactory, endpointConfiguration, endpointInvoker);
        String methodName = "SibRaDynamicDestinationEndpointActivation";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaDynamicDestinationEndpointActivation", (Object)new Object[]{resourceAdapter, messageEndpointFactory, endpointConfiguration, endpointInvoker});
        }
        JsMessagingEngine[] activeMessagingEngines = SibRaEngineComponent.registerMessagingEngineListener((SibRaMessagingEngineListener)this, (String)this._endpointConfiguration.getBusName());
        for (int i = 0; i < activeMessagingEngines.length; ++i) {
            this.addMessagingEngine(activeMessagingEngines[i]);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaDynamicDestinationEndpointActivation");
        }
    }

    @Override
    protected synchronized void addMessagingEngine(JsMessagingEngine messagingEngine) {
        String methodName = "addMessagingEngine";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"addMessagingEngine", (Object)messagingEngine);
        }
        SibRaMessagingEngineConnection connection = null;
        try {
            connection = this.getConnection(messagingEngine);
            SICoreConnection coreConnection = connection.getConnection();
            if (coreConnection instanceof SICoreConnection) {
                SibRaDestinationListener destinationListener = new SibRaDestinationListener(connection, this._messageEndpointFactory);
                DestinationType destinationType = this._endpointConfiguration.getDestinationType();
                SIDestinationAddress[] destinations = coreConnection.addDestinationListener(null, (DestinationListener)destinationListener, destinationType, DestinationAvailability.RECEIVE);
                for (int j = 0; j < destinations.length; ++j) {
                    try {
                        connection.createListener(destinations[j], this._messageEndpointFactory);
                        continue;
                    }
                    catch (ResourceException exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "addMessagingEngine"), (String)FFDC_PROBE_1, (Object)this);
                        SibTr.error((TraceComponent)TRACE, (String)"CREATE_LISTENER_FAILED_CWSIV0803", (Object)new Object[]{exception, destinations[j].getDestinationName(), messagingEngine.getName(), messagingEngine.getBusName()});
                    }
                }
            }
        }
        catch (SIException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "addMessagingEngine"), (String)FFDC_PROBE_2, (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"ADD_DESTINATION_LISTENER_FAILED_CWSIV0804", (Object)new Object[]{exception, messagingEngine.getName(), messagingEngine.getBusName()});
            this.closeConnection(messagingEngine);
        }
        catch (ResourceException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "addMessagingEngine"), (String)FFDC_PROBE_3, (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"CREATE_CONNECTION_FAILED_CWSIV0801", (Object)new Object[]{exception, messagingEngine.getName(), messagingEngine.getBusName()});
            this.closeConnection(messagingEngine);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"addMessagingEngine");
        }
    }

    @Override
    void sessionError(SibRaMessagingEngineConnection connection, ConsumerSession session, Throwable throwable) {
        if (throwable instanceof SISessionDroppedException) {
            SIDestinationAddress destination = session.getDestinationAddress();
            SibTr.warning((TraceComponent)TRACE, (String)"SESSION_DROPPED_CWSIV0808", (Object)new Object[]{destination.getDestinationName(), connection.getConnection().getMeName(), destination.getBusName(), throwable});
        } else if (!(throwable instanceof SINotPossibleInCurrentConfigurationException)) {
            SIDestinationAddress destination = session.getDestinationAddress();
            SibTr.error((TraceComponent)TRACE, (String)"SESSION_ERROR_CWSIV0806", (Object)new Object[]{throwable, destination.getDestinationName(), connection.getConnection().getMeName(), destination.getBusName(), this});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void connectionError(SibRaMessagingEngineConnection connection, SIException exception) {
        SibTr.error((TraceComponent)TRACE, (String)"CONNECTION_ERROR_CWSIV0807", (Object)new Object[]{exception, connection.getConnection().getMeName(), this});
        Map map = this._connections;
        synchronized (map) {
            this._connections.remove(connection.getConnection().getMeUuid());
        }
        connection.close();
    }

    @Override
    void messagingEngineTerminated(SibRaMessagingEngineConnection connection) {
    }

    @Override
    void messagingEngineQuiescing(SibRaMessagingEngineConnection connection) {
    }

    public void messagingEngineInitializing(JsMessagingEngine messagingEngine) {
    }

    public void messagingEngineDestroyed(JsMessagingEngine messagingEngine) {
    }

    public void messagingEngineReloaded(JsMessagingEngine engine) {
    }

    private static final class SibRaDestinationListener
    implements DestinationListener {
        private final SibRaMessagingEngineConnection _connection;
        private MessageEndpointFactory _messageEndpointFactory;

        private SibRaDestinationListener(SibRaMessagingEngineConnection connection, MessageEndpointFactory messageEndpointFactory) {
            String methodName = "SibRaDestinationListener";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"SibRaDestinationListener", (Object)new Object[]{connection, messageEndpointFactory});
            }
            this._connection = connection;
            this._messageEndpointFactory = messageEndpointFactory;
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"SibRaDestinationListener");
            }
        }

        public void destinationAvailable(SICoreConnection connection, SIDestinationAddress destination, DestinationAvailability availability) {
            String methodName = "destinationAvailable";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"destinationAvailable", (Object)new Object[]{connection, destination, availability});
            }
            try {
                this._connection.createListener(destination, this._messageEndpointFactory);
            }
            catch (ResourceException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "destinationAvailable"), (String)SibRaDynamicDestinationEndpointActivation.FFDC_PROBE_4, (Object)this);
                SibTr.error((TraceComponent)TRACE, (String)"CREATE_LISTENER_FAILED_CWSIV0805", (Object)new Object[]{exception, destination.getDestinationName(), connection.getMeName(), destination.getBusName()});
            }
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"destinationAvailable");
            }
        }

        public String toString() {
            SibRaStringGenerator generator = new SibRaStringGenerator(this);
            return generator.getStringRepresentation();
        }
    }
}

