/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.JmsSharedUtils;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import java.lang.reflect.Method;
import java.util.Map;

final class JmsJcaEndpointInvokerImpl
implements SibRaEndpointInvoker {
    private static Method ON_MESSAGE_METHOD;
    private JmsSharedUtils _jmsUtils;
    private static final TraceComponent TRACE;
    private static final TraceNLS NLS;
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String CLASS_NAME;
    private Map passThruProps;

    JmsJcaEndpointInvokerImpl(Map passThruProps_param) throws ResourceAdapterInternalException {
        String methodName = "JmsJcaEndpointInvokerImpl";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaEndpointInvokerImpl", (Object)passThruProps_param);
        }
        try {
            this._jmsUtils = JmsInternalsFactory.getSharedUtils();
        }
        catch (JMSException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".JmsJcaEndpointInvokerImpl"), (String)FFDC_PROBE_2, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UTILITY_CLASS_CWSJR1481", new Object[]{exception}, null), (Throwable)exception);
        }
        this.passThruProps = passThruProps_param;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaEndpointInvokerImpl");
        }
    }

    public Method getEndpointMethod() throws ResourceAdapterInternalException {
        String methodName = "getEndpointMethod";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getEndpointMethod");
        }
        if (ON_MESSAGE_METHOD == null) {
            try {
                ON_MESSAGE_METHOD = MessageListener.class.getMethod("onMessage", Message.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "getEndpointMethod"), (String)FFDC_PROBE_2, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("ON_MESSAGE_CWSJR1483", new Object[]{exception}, null), (Throwable)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getEndpointMethod", (Object)ON_MESSAGE_METHOD);
        }
        return ON_MESSAGE_METHOD;
    }

    public boolean invokeEndpoint(MessageEndpoint endpoint, SIBusMessage message, AbstractConsumerSession session, SITransaction transaction, String debugMEName) throws ResourceAdapterInternalException {
        boolean success;
        String methodName = "invokeEndpoint";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"invokeEndpoint", (Object)new Object[]{endpoint, message, session, transaction});
        }
        if (!(endpoint instanceof MessageListener)) {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNEXPECTED_ENDPOINT_CWSJR1482", new Object[]{endpoint, MessageListener.class}, null));
        }
        MessageListener listener = (MessageListener)endpoint;
        try {
            Message jmsMessage = this._jmsUtils.inboundMessagePath(message, null, this.passThruProps);
            if (debugMEName != null && !debugMEName.equals("")) {
                if (message instanceof JsJmsMessage) {
                    ((JsJmsMessage)message).setObjectProperty("MEName", (Object)debugMEName);
                } else if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)TRACE, (String)("Can not set MDB location in message as the message is not a JsJmsMessage - its a " + jmsMessage.getClass().getName()));
                }
            }
            listener.onMessage(jmsMessage);
            success = true;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)(CLASS_NAME + "." + "invokeEndpoint"), (String)FFDC_PROBE_1, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Throwable)exc);
            }
            success = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"invokeEndpoint", (Object)success);
        }
        return success;
    }

    static {
        TRACE = SibTr.register(JmsJcaEndpointInvokerImpl.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
        NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
        CLASS_NAME = JmsJcaEndpointInvokerImpl.class.getName();
    }
}

