/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class MessageProxyInvocationHandler
implements InvocationHandler {
    private static TraceComponent tc = SibTr.register(MessageProxyInvocationHandler.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private final Message actualMessageObject;

    MessageProxyInvocationHandler(Message msgObject) {
        this.actualMessageObject = msgObject;
    }

    Message getMessage() {
        return this.actualMessageObject;
    }

    @Override
    @FFDCIgnore(value={InvocationTargetException.class})
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"invoke", (Object)method.toGenericString());
        }
        if (this.actualMessageObject instanceof JmsMessageImpl && ((JmsMessageImpl)this.actualMessageObject).isAsynSendInProgress()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Application is trying to access message object.. when asysn send is in progress.. throwing JMSException");
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_MESSAGE_ACCESS_CWSIA0516E", null, tc);
        }
        Object retObject = null;
        try {
            retObject = method.invoke((Object)this.actualMessageObject, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"invoke", (Object)retObject);
        }
        return retObject;
    }
}

