/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal.naming;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.naming.EJBLocalNamingHelper;
import com.ibm.ws.ejbcontainer.osgi.EJBHomeRuntime;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBBinding;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBNamingInstancer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={EJBLocalNamingHelper.class, EJBLocalNamingHelperImpl.class})
public class EJBLocalNamingHelperImpl
extends EJBNamingInstancer
implements EJBLocalNamingHelper<EJBBinding> {
    private static final TraceComponent tc = Tr.register(EJBLocalNamingHelperImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private final HashMap<String, EJBBinding> EJBLocalBindings = new HashMap();
    private HashMap<String, Collection<NameClassPair>> EJBLocalContextsCache = null;
    private final ReentrantReadWriteLock javaColonLock = new ReentrantReadWriteLock();
    static final long serialVersionUID = -1542574105303519713L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(String name) throws NamingException {
        EJBBinding binding;
        ReentrantReadWriteLock.ReadLock readLock = this.javaColonLock.readLock();
        readLock.lock();
        try {
            binding = this.EJBLocalBindings.get(name);
        }
        finally {
            readLock.unlock();
        }
        if (binding != null && binding.isAmbiguousReference) {
            this.throwAmbiguousEJBReferenceException(binding, name);
        }
        return this.initializeEJB(binding, "ejblocal:" + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends NameClassPair> listInstances(String context, String name) throws NamingException {
        String contextName = context.isEmpty() ? name : context + "/" + name;
        String contextKey = contextName + (name.isEmpty() ? "" : "/");
        boolean root = contextKey.isEmpty();
        int contextIndex = root ? 0 : contextKey.lastIndexOf("/") + 1;
        ReentrantReadWriteLock.ReadLock readLock = this.javaColonLock.readLock();
        readLock.lock();
        Collection<NameClassPair> instances = null;
        try {
            Collection<NameClassPair> collection = instances = this.EJBLocalContextsCache != null ? this.EJBLocalContextsCache.get(contextName) : null;
            if (instances != null) {
                Collection<NameClassPair> collection2 = instances;
                return collection2;
            }
            String instanceName = null;
            String instanceType = null;
            HashMap<String, NameClassPair> allInstances = new HashMap<String, NameClassPair>();
            for (Map.Entry<String, EJBBinding> entry : this.EJBLocalBindings.entrySet()) {
                String key = entry.getKey();
                if (root || key.startsWith(contextKey)) {
                    int instanceIndex = key.indexOf("/", contextIndex + 1);
                    if (instanceIndex == -1) {
                        instanceName = key.substring(contextIndex);
                        instanceType = entry.getValue().interfaceName;
                    } else {
                        instanceName = key.substring(contextIndex, instanceIndex);
                        instanceType = Context.class.getName();
                    }
                    allInstances.put(instanceName, new NameClassPair(instanceName, instanceType));
                    continue;
                }
                if (!key.equals(contextName)) continue;
                throw new NotContextException("ejblocal:" + contextName);
            }
            instances = allInstances.values();
            if (instances.size() > 0) {
                if (this.EJBLocalContextsCache == null) {
                    this.EJBLocalContextsCache = new HashMap();
                }
                this.EJBLocalContextsCache.put(contextName, instances);
            }
        }
        finally {
            readLock.unlock();
        }
        return instances;
    }

    @Reference(service=EJBHomeRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEJBHomeRuntime(ServiceReference<EJBHomeRuntime> ref) {
        this.homeRuntime = true;
    }

    protected void unsetEJBHomeRuntime(ServiceReference<EJBHomeRuntime> ref) {
        this.homeRuntime = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public synchronized boolean bind(EJBBinding binding, String name, boolean isSimpleName, boolean isDefaultBinding) throws NamingException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        boolean notAmbiguous = true;
        EJBBinding newBinding = new EJBBinding(binding.homeRecord, binding.interfaceName, binding.interfaceIndex, binding.isLocal);
        if (name.toLowerCase().startsWith("ejblocal:")) {
            name = name.substring(9);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("bind: " + name), (Object[])new Object[0]);
        }
        EJBBinding previousBinding = this.EJBLocalBindings.get(name);
        if (isSimpleName) {
            newBinding.setAmbiguousReference();
            notAmbiguous = false;
        }
        if (previousBinding != null) {
            if (isDefaultBinding) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"found ambiguous default binding", (Object[])new Object[0]);
                }
            } else {
                OnErrorUtil.OnError onError = ContainerProperties.customBindingsOnErr;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("found ambiguous binding and customBindingsOnErr=" + onError.toString()), (Object[])new Object[0]);
                }
                BeanMetaData bmd = newBinding.homeRecord.getBeanMetaData();
                BeanMetaData oldbmd = previousBinding.homeRecord.getBeanMetaData();
                switch (onError) {
                    case WARN: {
                        Tr.warning((TraceComponent)tc, (String)"NAME_ALREADY_BOUND_WARN_CNTR0338W", (Object[])new Object[]{newBinding.interfaceName, bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), bmd.j2eeName.getApplication(), name, previousBinding.interfaceName, oldbmd.j2eeName.getComponent(), oldbmd.j2eeName.getModule(), oldbmd.j2eeName.getApplication()});
                        break;
                    }
                    case FAIL: {
                        Tr.error((TraceComponent)tc, (String)"NAME_ALREADY_BOUND_WARN_CNTR0338W", (Object[])new Object[]{newBinding.interfaceName, bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), bmd.j2eeName.getApplication(), name, previousBinding.interfaceName, oldbmd.j2eeName.getComponent(), oldbmd.j2eeName.getModule(), oldbmd.j2eeName.getApplication()});
                        throw new NamingException("The " + newBinding.interfaceName + " interface of the " + bmd.j2eeName.getComponent() + " bean in the " + bmd.j2eeName.getModule() + " module of the application cannot be bound to " + name + ", a bean is already bound to that location.");
                    }
                    case IGNORE: {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"customBindingsOnErr is IGNORE, not binding", (Object[])new Object[0]);
                        }
                        return false;
                    }
                }
            }
            newBinding.setAmbiguousReference();
            newBinding.addJ2EENames(previousBinding.getJ2EENames());
            notAmbiguous = false;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            this.EJBLocalBindings.put(name, newBinding);
        }
        finally {
            writeLock.unlock();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("bind: notAmbiguous = " + notAmbiguous));
        }
        return notAmbiguous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public void unbind(String name) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (name.toLowerCase().startsWith("ejblocal:")) {
            name = name.substring(9);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("unbinding: " + name), (Object[])new Object[0]);
        }
        EJBBinding removed = null;
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            if (this.EJBLocalContextsCache != null) {
                this.EJBLocalContextsCache.clear();
            }
            removed = this.EJBLocalBindings.remove(name);
        }
        finally {
            writeLock.unlock();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("unbind: " + (removed != null)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBindings(List<String> names) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            if (this.EJBLocalContextsCache != null) {
                this.EJBLocalContextsCache.clear();
            }
            for (String name : names) {
                if (name.toLowerCase().startsWith("ejblocal:")) {
                    name = name.substring(9);
                }
                EJBBinding removed = this.EJBLocalBindings.remove(name);
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("unbinding: " + name + " : " + (removed != null)), (Object[])new Object[0]);
            }
        }
        finally {
            writeLock.unlock();
        }
    }
}

