/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.index;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.processor.utils.linkedlist.Cursor;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.NoSuchElementException;

public class FilteredIndexIterator
implements SIMPIterator {
    private static final TraceComponent tc = SibTr.register(FilteredIndexIterator.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Index index;
    private Cursor cursor;
    private IndexFilter filter;
    private Index.Entry next;
    private Index.Entry removable;

    public FilteredIndexIterator(Index index) {
        this(index, null);
    }

    public FilteredIndexIterator(Index index, IndexFilter filter) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"FilteredIndexIterator", (Object)new Object[]{index, filter});
        }
        this.index = index;
        this.cursor = index.newCursor();
        this.filter = filter;
        this.next = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"FilteredIndexIterator", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasNext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasNext");
        }
        if (this.next == null) {
            Index index = this.index;
            synchronized (index) {
                this.next = (Index.Entry)this.cursor.next();
                if (this.filter != null) {
                    while (this.next != null && !this.filter.matches(this.next.type)) {
                        this.next = (Index.Entry)this.cursor.next();
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasNext", (Object)new Boolean(this.next != null));
        }
        return this.next != null;
    }

    public synchronized Object next() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"next");
        }
        Object next = null;
        if (!this.hasNext()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"next", (Object)"NoSuchElementException");
            }
            throw new NoSuchElementException(nls.getFormattedMessage("NO_ELEMENTS_ERROR_CWSIP0601", null, null));
        }
        next = this.next.data;
        this.removable = this.next;
        this.next = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"next", (Object)next);
        }
        return next;
    }

    public synchronized void remove() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove");
        }
        if (this.removable == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"remove", (Object)"IllegalStateException");
            }
            throw new IllegalStateException(nls.getFormattedMessage("NO_ELEMENTS_ERROR_CWSIP0602", null, null));
        }
        this.index.remove(this.removable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"finished");
        }
        this.cursor.finished();
        this.cursor = null;
        FilteredIndexIterator filteredIndexIterator = this;
        synchronized (filteredIndexIterator) {
            this.filter = null;
            this.index = null;
            this.next = null;
            this.removable = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"finished");
        }
    }
}

