/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.SourceStream;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.runtime.SIMPTransmitMessageControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.QueuedMessage;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Date;

public class TransmitMessage
extends AbstractControlAdapter
implements SIMPTransmitMessageControllable {
    private Stream _stream;
    private long _tick;
    private long _previousTick;
    private long _messageID;
    private DownstreamControl _downControl;
    private SIMPMessage _msg;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(TransmitMessage.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public TransmitMessage(long msgStoreid, Stream stream, DownstreamControl downControl) throws SIResourceException {
        this._messageID = msgStoreid;
        this._downControl = downControl;
        SIMPMessage msg = this.getSIMPMessage();
        this._tick = msg.getMessage().getGuaranteedValueValueTick();
        this._stream = stream;
        this._previousTick = msg.getMessage().getGuaranteedValueStartTick() - 1L;
    }

    public TransmitMessage(SIMPMessage msg, Stream stream) {
        this._msg = msg;
        this._tick = msg.getMessage().getGuaranteedValueValueTick();
        this._stream = stream;
        this._previousTick = msg.getMessage().getGuaranteedValueStartTick() - 1L;
    }

    private TickRange getTickRange() {
        return this._stream.getTickRange(this._tick);
    }

    public SIMPMessage getSIMPMessage() throws SIResourceException {
        SIMPMessage message;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIMPMessage");
        }
        if ((message = this._msg) == null) {
            message = this._downControl.getValueMessage(this._messageID);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIMPMessage", (Object)message);
        }
        return message;
    }

    public JsMessage getJsMessage() throws SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJsMessage");
        }
        this.assertValidControllable();
        JsMessage jsMessage = null;
        try {
            jsMessage = this.getSIMPMessage().getMessage();
        }
        catch (SIResourceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getJsMessage", (Object)((Object)e));
            }
            throw new SIMPRuntimeOperationFailedException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJsMessage", (Object)jsMessage);
        }
        return jsMessage;
    }

    public String getState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        TickRange range = this.getTickRange();
        long firstSendPending = Long.MAX_VALUE;
        if (this._stream instanceof SourceStream) {
            firstSendPending = ((SourceStream)this._stream).getFirstMsgOutsideWindow();
        }
        SIMPTransmitMessageControllable.State state = SIMPTransmitMessageControllable.State.COMPLETE;
        if (range.type == 2) {
            state = SIMPTransmitMessageControllable.State.COMMITTING;
        } else if (range.type == 3 && this._tick < firstSendPending) {
            state = SIMPTransmitMessageControllable.State.PENDING_ACKNOWLEDGEMENT;
        } else if (range.type == 3 && this._tick >= firstSendPending) {
            state = SIMPTransmitMessageControllable.State.PENDING_SEND;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)state);
        }
        return state.toString();
    }

    public long getStartTick() {
        return this._tick;
    }

    public long getEndTick() {
        return this._tick;
    }

    public void moveMessage(boolean discard) throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveMessage", (Object)discard);
        }
        this.assertValidControllable();
        QueuedMessage queuedMessage = null;
        try {
            queuedMessage = (QueuedMessage)this.getSIMPMessage().getControlAdapter();
        }
        catch (SIResourceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"moveMessage", (Object)((Object)e));
            }
            throw new SIMPRuntimeOperationFailedException((Throwable)e);
        }
        if (queuedMessage != null) {
            queuedMessage.moveMessage(discard);
            try {
                this._stream.writeSilenceForced(this._tick);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.TransmitMessage.moveMessage", (String)"1:245:1.42", (Object)this);
                SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"TransmitMessage.moveMessage", "1:253:1.42", e, new Long(this._tick)}, null), (Throwable)e);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"moveMessage", (Object)((Object)finalE));
                }
                throw finalE;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveMessage");
        }
    }

    public long getSequenceID() {
        return this._tick;
    }

    public Date getProducedTime() {
        Date producedTime = null;
        try {
            producedTime = new Date(this.getSIMPMessage().getMessage().getTimestamp());
        }
        catch (SIResourceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        return producedTime;
    }

    public long getPreviousSequenceId() {
        return this._previousTick;
    }

    public Stream getStream() {
        return this._stream;
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String id = "" + this._messageID;
        SibTr.exit((TraceComponent)tc, (String)"getId", (Object)id);
        return id;
    }

    public String getName() {
        return null;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        TickRange range = this.getTickRange();
        if (range.type != 2 && range.type != 3) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"TransmitMessage.assertValidControllable", "1:346:1.42", new Long(this._tick)}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            throw finalE;
        }
    }

    @Override
    public void dereferenceControllable() {
        this._tick = -1L;
        this._stream = null;
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }

    public String getTransactionId() {
        String tranID = null;
        try {
            PersistentTranId pTranID = this.getSIMPMessage().getTransactionId();
            if (pTranID != null) {
                tranID = pTranID.toTMString();
            }
        }
        catch (SIResourceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        return tranID;
    }

    public void putMessageToExceptionDestination() {
    }

    public long getMEArrivalTimestamp() throws SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMEArrivalTimestamp");
        }
        long timestamp = this.getJsMessage().getCurrentMEArrivalTimestamp();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMEArrivalTimestamp", (Object)new Long(timestamp));
        }
        return timestamp;
    }

    class TransmitID {
        Reliability reliability;
        int priority;
        long tick;

        TransmitID(String id) {
            String[] tokens = id.split(":");
            this.reliability = Reliability.getReliabilityByName((String)tokens[0]);
            this.priority = Integer.parseInt(tokens[1]);
            this.tick = Long.parseLong(tokens[2]);
        }

        public int getPriority() {
            return this.priority;
        }

        public Reliability getReliability() {
            return this.reliability;
        }

        public long getTickValue() {
            return this.tick;
        }
    }
}

