/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.processor.MPLockedMessageEnumeration;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPILockedMessageEnumeration;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

final class SingleLockedMessageEnumerationImpl
implements MPLockedMessageEnumeration {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsir = TraceNLS.getTraceNLS((String)"com.ibm.wsspi.sib.core.CWSIRMessages");
    private static TraceComponent tc = SibTr.register(SingleLockedMessageEnumerationImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private JSLocalConsumerPoint _localConsumerPoint;
    private boolean _isPubsub;
    private boolean _seenSingleMessage = false;
    private boolean _messageAvailable = false;
    private SIMPMessage _singleMessage = null;
    private boolean _validState = true;

    SingleLockedMessageEnumerationImpl(JSLocalConsumerPoint localConsumerPoint, SIMPMessage message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SingleLockedMessageEnumerationImpl", (Object)new Object[]{localConsumerPoint, message});
        }
        this._localConsumerPoint = localConsumerPoint;
        this._isPubsub = localConsumerPoint.getConsumerManager().getDestination().isPubSub();
        this._singleMessage = message;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this._singleMessage != null) {
            SibTr.debug((Object)this._localConsumerPoint, (TraceComponent)tc, (String)("verboseMsg OUT : " + this._singleMessage.getMessage().toVerboseString()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SingleLockedMessageEnumerationImpl", (Object)this);
        }
    }

    void clearMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearMessage");
            SibTr.exit((TraceComponent)tc, (String)"clearMessage");
        }
        this._validState = false;
        this._singleMessage = null;
    }

    void newMessage(SIMPMessage message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newMessage", (Object)message);
            SibTr.exit((TraceComponent)tc, (String)"newMessage");
        }
        this._validState = true;
        this._singleMessage = message;
        this._seenSingleMessage = false;
        this._messageAvailable = false;
    }

    public SIBusMessage nextLocked() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)this);
        }
        this.checkValidState("nextLocked");
        this._localConsumerPoint.checkNotClosed();
        if (this._seenSingleMessage || this._singleMessage == null) {
            this._messageAvailable = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"nextLocked", null);
            }
            return null;
        }
        this._seenSingleMessage = true;
        JsMessage msg = null;
        if (this._isPubsub && ((ConnectionImpl)this._localConsumerPoint.getConsumerSession().getConnection()).getMessageCopiedWhenReceived()) {
            try {
                msg = this._singleMessage.getMessage().getReceived();
            }
            catch (MessageCopyFailedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.SingleLockedMessageEnumerationImpl.nextLocked", (String)"1:172:1.44", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.SingleLockedMessageEnumerationImpl", "1:179:1.44", e});
                this._seenSingleMessage = false;
                this._messageAvailable = false;
                if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)((Object)e));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.SingleLockedMessageEnumerationImpl", "1:193:1.44", e}, null), (Throwable)e);
            }
        } else {
            msg = this._singleMessage.getMessage();
        }
        this._messageAvailable = true;
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
            UserTrace.trace_Receive(null, msg, this._localConsumerPoint.getConsumerSession().getDestinationAddress(), this._localConsumerPoint.getConsumerSession().getIdInternal());
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)msg);
        }
        return msg;
    }

    public void unlockCurrent() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)this);
        }
        this.deleteCurrent(null);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent");
        }
    }

    public void unlockCurrent(boolean incrementUnlockCount) throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)new Object[]{this, new Boolean(incrementUnlockCount)});
        }
        this.deleteCurrent(null);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent");
        }
    }

    public void deleteCurrent(SITransaction simpTran) throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)this);
        }
        this.checkValidState("deleteCurrent");
        this._localConsumerPoint.checkNotClosed();
        if (!this._messageAvailable) {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)"Invalid current Message");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_MESSAGE_ERROR_CWSIP0191", new Object[]{this._localConsumerPoint.getConsumerManager().getDestination().getName(), this._localConsumerPoint.getConsumerManager().getMessageProcessor().getMessagingEngineName()}, null));
        }
        this._singleMessage = null;
        this._messageAvailable = false;
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent");
        }
    }

    public void deleteSeen(SITransaction simpTran) throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen", (Object)new Object[]{this, simpTran});
        }
        this.deleteCurrent(simpTran);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen");
        }
    }

    public ConsumerSession getConsumerSession() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getConsumerSession", (Object)this);
        }
        this.checkValidState("getConsumerSession");
        this._localConsumerPoint.checkNotClosed();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getConsumerSession", (Object)this._localConsumerPoint.getConsumerSession());
        }
        return this._localConsumerPoint.getConsumerSession();
    }

    public void resetCursor() throws SISessionUnavailableException, SISessionDroppedException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"resetCursor", (Object)this);
        }
        this.checkValidState("resetCursor");
        this._localConsumerPoint.checkNotClosed();
        this._seenSingleMessage = false;
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"resetCursor");
        }
    }

    public int getRemainingMessageCount() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getRemainingMessageCount", (Object)this);
        }
        this.checkValidState("getRemainingMessageCount");
        this._localConsumerPoint.checkNotClosed();
        int remaining = 0;
        if (!this._seenSingleMessage) {
            remaining = 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getRemainingMessageCount", (Object)new Integer(remaining));
        }
        return remaining;
    }

    private void checkValidState(String method) throws SIIncorrectCallException {
        if (!this._validState) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkValidState");
            }
            SIIncorrectCallException e = new SIIncorrectCallException(nls_cwsir.getFormattedMessage("LME_ERROR_CWSIR0131", new Object[]{method}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkValidState", (Object)((Object)e));
            }
            throw e;
        }
    }

    public boolean hasNext() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"hasNext", (Object)this);
        }
        this.checkValidState("hasNext");
        this._localConsumerPoint.checkNotClosed();
        boolean hasNext = false;
        if (!this._seenSingleMessage) {
            hasNext = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"hasNext", (Object)new Boolean(hasNext));
        }
        return hasNext;
    }

    public SIBusMessage peek() throws SISessionUnavailableException, SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"peek");
        }
        this.checkValidState("peek");
        this._localConsumerPoint.checkNotClosed();
        JsMessage nextMessage = null;
        if (!this._seenSingleMessage) {
            if (this._isPubsub && ((ConnectionImpl)this._localConsumerPoint.getConsumerSession().getConnection()).getMessageCopiedWhenReceived()) {
                try {
                    nextMessage = this._singleMessage.getMessage().getReceived();
                }
                catch (MessageCopyFailedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.SingleLockedMessageEnumerationImpl.peek", (String)"1:456:1.44", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.SingleLockedMessageEnumerationImpl", "1:463:1.44", e});
                    this._seenSingleMessage = false;
                    this._messageAvailable = false;
                    if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"peek", (Object)((Object)e));
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.SingleLockedMessageEnumerationImpl", "1:477:1.44", e}, null), (Throwable)e);
                }
            } else {
                nextMessage = this._singleMessage.getMessage();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"peek", (Object)nextMessage);
        }
        return nextMessage;
    }
}

