/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.ConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;

public class ConsumerList {
    private static final TraceComponent tc = SibTr.register(ConsumerList.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private HashMap _consumers;
    private long _consumerCount = 0L;
    private MessageProcessor _messageProcessor = null;

    public ConsumerList(MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerList", (Object)messageProcessor);
        }
        this._consumers = new HashMap();
        this._messageProcessor = messageProcessor;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerList", (Object)this);
        }
    }

    synchronized void remove(ConsumerSessionImpl consumer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)consumer);
        }
        this._consumers.remove(new Long(consumer.getIdInternal()));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    synchronized ConsumerSessionImpl get(long id) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"get", (Object)new Long(id));
        }
        ConsumerSessionImpl consumer = null;
        if (this._messageProcessor.isStarted()) {
            consumer = (ConsumerSessionImpl)this._consumers.get(new Long(id));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get", consumer);
        }
        return consumer;
    }

    synchronized void add(ConsumerSessionImpl consumer) {
        consumer.setId(this._consumerCount);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"add", (Object)new Long(consumer.getIdInternal()));
        }
        this._consumers.put(new Long(this._consumerCount), consumer);
        ++this._consumerCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"add");
        }
    }
}

