/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.ws.logging.collector.Formatter;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.LogTraceData;
import com.ibm.ws.logging.internal.impl.BaseTraceFormatter;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.JsonLogHandler;
import com.ibm.wsspi.collector.manager.SynchronousHandler;
import java.util.List;

public class MessageLogHandler
extends JsonLogHandler
implements SynchronousHandler,
Formatter {
    private BaseTraceService.TraceWriter traceWriterOriginal;
    public static final String COMPONENT_NAME = "com.ibm.ws.logging.internal.impl.MessageLogHandler";
    private String format = "simple";
    private BaseTraceFormatter basicFormatter = null;

    public MessageLogHandler(String serverName, String wlpUserDir, List<String> sourcesList) {
        super(serverName, wlpUserDir, sourcesList);
    }

    @Override
    public String getHandlerName() {
        return COMPONENT_NAME;
    }

    @Override
    public void setWriter(Object writer) {
        this.traceWriterOriginal = (BaseTraceService.TraceWriter)writer;
    }

    @Override
    public void synchronousWrite(Object event) {
        BaseTraceService.TraceWriter traceWriter = this.traceWriterOriginal;
        if (traceWriter == null) {
            return;
        }
        String currFormat = this.format;
        GenericData genData = null;
        if (!(event instanceof GenericData)) {
            throw new IllegalArgumentException("event not an instance of GenericData");
        }
        genData = (GenericData)event;
        String eventSourceName = this.getSourceNameFromDataObject(genData);
        String messageOutput = null;
        if (currFormat.equals("json") || !eventSourceName.equals("com.ibm.ws.logging.source.message")) {
            if (genData.getJsonMessage() == null) {
                String jsonMessage = null;
                if (appsWriteJson && event instanceof LogTraceData && (jsonMessage = ((LogTraceData)event).getMessage()) != null) {
                    jsonMessage = jsonMessage.trim();
                }
                if (!MessageLogHandler.isJSON(jsonMessage)) {
                    jsonMessage = (String)this.formatEvent(eventSourceName, "memory", event, null, -1);
                }
                genData.setJsonMessage(jsonMessage);
            }
            messageOutput = genData.getJsonMessage();
        } else if ((currFormat.equals("simple") || currFormat.equals("basic")) && this.basicFormatter != null) {
            messageOutput = this.basicFormatter.messageLogFormat(genData);
        } else if (currFormat.equals("tbasic") && this.basicFormatter != null) {
            messageOutput = this.basicFormatter.messageLogFormatTBasic(genData);
        }
        if (messageOutput != null && traceWriter != null) {
            traceWriter.writeRecord(messageOutput);
        }
    }

    public void setBasicFormatter(BaseTraceFormatter formatter) {
        this.basicFormatter = formatter;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

