/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.ws.logging.collector.CollectorJsonHelpers;
import com.ibm.ws.logging.collector.CollectorJsonUtils_JSON;
import com.ibm.ws.logging.data.AccessLogData;
import com.ibm.ws.logging.data.AccessLogDataFormatter;
import com.ibm.ws.logging.data.AuditData;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.logging.data.GCData;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.JSONObject;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.LogTraceData;
import java.util.ArrayList;

public class CollectorJsonUtils {
    public static final int MAX_USER_AGENT_LENGTH = 2048;
    private static final int LOGSTASH_KEY = 1;

    public static String getEventType(String source, String location) {
        return CollectorJsonHelpers.getEventType(source, location);
    }

    public static String jsonifyEvent(Object event, String eventType, String serverName, String wlpUserDir, String serverHostName, String collectorVersion, String[] tags, int maxFieldLength) {
        if (!collectorVersion.startsWith("1.0")) {
            if (collectorVersion.startsWith("JSON")) {
                return CollectorJsonUtils_JSON.jsonifyEvent(event, eventType, serverName, wlpUserDir, serverHostName, tags, maxFieldLength);
            }
        } else {
            if (eventType.equals("liberty_gc")) {
                return CollectorJsonUtils.jsonifyGCEvent(wlpUserDir, serverName, serverHostName, event, tags);
            }
            if (eventType.equals("liberty_message")) {
                return CollectorJsonUtils.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_message", event, tags);
            }
            if (eventType.equals("liberty_trace")) {
                return CollectorJsonUtils.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_trace", event, tags);
            }
            if (eventType.equals("liberty_ffdc")) {
                return CollectorJsonUtils.jsonifyFFDC(maxFieldLength, wlpUserDir, serverName, serverHostName, event, tags);
            }
            if (eventType.equals("liberty_accesslog")) {
                return CollectorJsonUtils.jsonifyAccess(wlpUserDir, serverName, serverHostName, event, tags);
            }
            if (eventType.equals("liberty_audit")) {
                return CollectorJsonUtils.jsonifyAudit(wlpUserDir, serverName, serverHostName, event, tags);
            }
        }
        return "";
    }

    private static String jsonifyGCEvent(String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        GCData gcData = (GCData)event;
        JSONObject.JSONObjectBuilder jsonBuilder = CollectorJsonHelpers.startGC();
        jsonBuilder.addField(gcData.getHeapKey(), gcData.getHeap(), false);
        jsonBuilder.addField(gcData.getUsedHeapKey(), gcData.getUsedHeap(), false);
        jsonBuilder.addField(gcData.getMaxHeapKey(), gcData.getMaxHeap(), false);
        long duration = gcData.getDuration() * 1000L;
        jsonBuilder.addField(gcData.getDurationKey(), duration, false);
        jsonBuilder.addField(gcData.getGcTypeKey(), gcData.getGcType(), false, true);
        jsonBuilder.addField(gcData.getReasonKey(), gcData.getReason(), false, true);
        String datetime = CollectorJsonHelpers.formatTime(gcData.getDatetime());
        jsonBuilder.addField(gcData.getDatetimeKey(), datetime, false, true);
        jsonBuilder.addField(gcData.getSequenceKey(), gcData.getSequence(), false, true);
        if (tags != null) {
            jsonBuilder.addPreformattedField("tags", CollectorJsonHelpers.jsonifyTags(tags));
        }
        return jsonBuilder.build().toString();
    }

    private static String jsonifyTraceAndMessage(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        LogTraceData logData = (LogTraceData)event;
        JSONObject.JSONObjectBuilder jsonBuilder = null;
        boolean isMessageEvent = eventType.equals("liberty_message");
        if (isMessageEvent) {
            jsonBuilder = CollectorJsonHelpers.startMessage(1);
        }
        if (!isMessageEvent) {
            jsonBuilder = CollectorJsonHelpers.startTrace(1);
        }
        String message = logData.getMessage();
        String loglevel = logData.getLoglevel();
        if (loglevel != null && (loglevel.equals("ENTRY") || loglevel.equals("EXIT"))) {
            message = CollectorJsonHelpers.jsonRemoveSpace(message);
        }
        StringBuilder formattedValue = new StringBuilder(CollectorJsonHelpers.formatMessage(message, maxFieldLength));
        String datetime = CollectorJsonHelpers.formatTime(logData.getDatetime());
        jsonBuilder.addField(LogTraceData.getMessageKey(1, isMessageEvent), formattedValue.toString(), false, true).addField(LogTraceData.getThreadIdKey(1, isMessageEvent), DataFormatHelper.padHexString(logData.getThreadId(), 8), false, true).addField(LogTraceData.getDatetimeKey(1, isMessageEvent), datetime, false, true).addField(LogTraceData.getModuleKey(1, isMessageEvent), logData.getModule(), false, true).addField(LogTraceData.getMessageIdKey(1, isMessageEvent), logData.getMessageId(), false, true).addField(LogTraceData.getSeverityKey(1, isMessageEvent), logData.getSeverity(), false, true).addField(LogTraceData.getMethodNameKey(1, isMessageEvent), logData.getMethodName(), false, true).addField(LogTraceData.getClassNameKey(1, isMessageEvent), logData.getClassName(), false, true).addField(LogTraceData.getSequenceKey(1, isMessageEvent), logData.getSequence(), false, true);
        String exceptionName = logData.getExceptionName();
        String throwable = logData.getThrowable();
        if (exceptionName != null && throwable != null) {
            jsonBuilder.addField(LogTraceData.getExceptionNameKey(1, isMessageEvent), exceptionName, false, true);
            jsonBuilder.addField(LogTraceData.getStackTraceKey(1, isMessageEvent), throwable, false, true);
        }
        ArrayList<KeyValuePair> extensions = null;
        KeyValuePairList kvpl = null;
        kvpl = logData.getExtensions();
        if (kvpl != null && kvpl.getKey().equals("extensions")) {
            extensions = kvpl.getList();
            for (KeyValuePair k : extensions) {
                String extKey = k.getKey();
                if (extKey.endsWith("_int")) {
                    jsonBuilder.addField(extKey, k.getIntValue(), false);
                    continue;
                }
                if (extKey.endsWith("_float")) {
                    jsonBuilder.addField(extKey, k.getFloatValue(), false);
                    continue;
                }
                if (extKey.endsWith("_long")) {
                    jsonBuilder.addField(extKey, k.getLongValue(), false);
                    continue;
                }
                if (extKey.endsWith("_bool")) {
                    jsonBuilder.addField(extKey, k.getBooleanValue(), false);
                    continue;
                }
                jsonBuilder.addField(extKey, k.getStringValue(), false, true);
            }
        }
        if (tags != null) {
            jsonBuilder.addPreformattedField("tags", CollectorJsonHelpers.jsonifyTags(tags));
        }
        return jsonBuilder.build().toString();
    }

    private static String jsonifyFFDC(int maxFieldLength, String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        FFDCData ffdcData = (FFDCData)event;
        JSONObject.JSONObjectBuilder jsonBuilder = CollectorJsonHelpers.startFFDC(1);
        String datetime = CollectorJsonHelpers.formatTime(ffdcData.getDatetime());
        String formattedValue = CollectorJsonHelpers.formatMessage(ffdcData.getStacktrace(), maxFieldLength);
        jsonBuilder.addField(FFDCData.getDatetimeKey(1), datetime, false, true).addField(FFDCData.getMessageKey(1), ffdcData.getMessage(), false, true).addField(FFDCData.getClassNameKey(1), ffdcData.getClassName(), false, true).addField(FFDCData.getExceptionNameKey(1), ffdcData.getExceptionName(), false, true).addField(FFDCData.getProbeIdKey(1), ffdcData.getProbeId(), false, true).addField(FFDCData.getThreadIdKey(1), DataFormatHelper.padHexString((int)ffdcData.getThreadId(), 8), false, true).addField(FFDCData.getStacktraceKey(1), formattedValue, false, true).addField(FFDCData.getObjectDetailsKey(1), ffdcData.getObjectDetails(), false, true).addField(FFDCData.getSequenceKey(1), ffdcData.getSequence(), false, true);
        if (tags != null) {
            jsonBuilder.addPreformattedField("tags", CollectorJsonHelpers.jsonifyTags(tags));
        }
        return jsonBuilder.build().toString();
    }

    private static String jsonifyAccess(String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        AccessLogData accessLogData = (AccessLogData)event;
        JSONObject.JSONObjectBuilder jsonBuilder = CollectorJsonHelpers.startAccessLog(1);
        AccessLogDataFormatter[] formatters = accessLogData.getFormatters();
        if (formatters[3] != null) {
            formatters[3].populate(jsonBuilder, accessLogData);
        } else if (formatters[2] != null) {
            formatters[2].populate(jsonBuilder, accessLogData);
        } else {
            throw new RuntimeException("There is no formatter available for this event.");
        }
        if (tags != null) {
            jsonBuilder.addPreformattedField("tags", CollectorJsonHelpers.jsonifyTags(tags));
        }
        return jsonBuilder.build().toString();
    }

    public static String jsonifyAudit(String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        KeyValuePair[] pairs = genData.getPairs();
        String key = null;
        JSONObject.JSONObjectBuilder jsonBuilder = CollectorJsonHelpers.startAudit(1);
        for (KeyValuePair kvp : pairs) {
            if (kvp == null || kvp.isList()) continue;
            key = kvp.getKey();
            if (key.equals("ibm_datetime") || key.equals("loggingEventTime")) {
                String datetime = CollectorJsonHelpers.formatTime(kvp.getLongValue());
                jsonBuilder.addField(AuditData.getDatetimeKey(1), datetime, false, true);
                continue;
            }
            if (key.equals("ibm_sequence") || key.equals("loggingSequenceNumber")) {
                jsonBuilder.addField(AuditData.getSequenceKey(1), kvp.getStringValue(), false, false);
                continue;
            }
            if (key.equals("ibm_threadId")) {
                jsonBuilder.addField(AuditData.getThreadIDKey(1), DataFormatHelper.padHexString(kvp.getIntValue(), 8), false, true);
                continue;
            }
            jsonBuilder.addField("ibm_audit_" + key, kvp.getStringValue(), false, false);
        }
        return jsonBuilder.build().toString();
    }
}

