/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SecretKeysHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecretKeysHandlerConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = -5228028387733656005L;
    private final boolean enabled;
    private final Map<String, SecretKeysHandler> handlers = new HashMap<String, SecretKeysHandler>();

    public SecretKeysHandlerConfigSourceInterceptor(boolean enabled, List<SecretKeysHandler> handlers) {
        this.enabled = enabled;
        for (SecretKeysHandler handler : handlers) {
            this.handlers.put(handler.getName(), handler);
        }
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        String handler;
        ConfigValue configValue = context.proceed(name);
        if (this.enabled && configValue != null && configValue.getValue() != null && (handler = configValue.getExtendedExpressionHandler()) != null) {
            return configValue.withValue(this.getSecretValue(handler, configValue.getValue()));
        }
        return configValue;
    }

    private String getSecretValue(String handlerName, String secretName) {
        SecretKeysHandler handler = this.handlers.get(handlerName);
        if (handler != null) {
            return handler.decode(secretName);
        }
        throw ConfigMessages.msg.secretKeyHandlerNotFound(handlerName);
    }
}

