/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.identitystore.ELHelper;
import io.openliberty.security.jakartasec.el.ELUtils;
import io.openliberty.security.oidcclientcore.client.LogoutConfig;
import jakarta.security.enterprise.authentication.mechanism.http.openid.LogoutDefinition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LogoutDefinitionWrapper
implements LogoutConfig {
    private static final TraceComponent tc = Tr.register(LogoutDefinitionWrapper.class, (String)"OpenIdConnect", (String)"io.openliberty.security.jakartasec.internal.resources.JakartaSecurity30Messages");
    private final LogoutDefinition logoutDefinition;
    private final ELHelper elHelper;
    private final Boolean notifyProvider;
    private final String redirectURI;
    private final Boolean accessTokenExpiry;
    private final Boolean identityTokenExpiry;
    static final long serialVersionUID = -996282734198500503L;

    public LogoutDefinitionWrapper(LogoutDefinition logoutDefinition) {
        this.logoutDefinition = logoutDefinition;
        this.elHelper = new ELHelper();
        this.notifyProvider = this.evaluateNotifyProvider(true);
        this.redirectURI = this.evaluateRedirectURI(true);
        this.accessTokenExpiry = this.evaluateAccessTokenExpiry(true);
        this.identityTokenExpiry = this.evaluateIdentityTokenExpiry(true);
    }

    public boolean isNotifyProvider() {
        return this.notifyProvider != null ? this.notifyProvider : this.evaluateNotifyProvider(false);
    }

    private Boolean evaluateNotifyProvider(boolean immediateOnly) {
        return ELUtils.evaluateBooleanAttribute("notifyProvider", this.logoutDefinition.notifyProvider(), false, this.logoutDefinition.notifyProviderExpression(), immediateOnly);
    }

    public String getRedirectURI() {
        return this.redirectURI != null ? this.redirectURI : this.evaluateRedirectURI(false);
    }

    private String evaluateRedirectURI(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("redirectURI", this.logoutDefinition.redirectURI(), "", immediateOnly);
    }

    public boolean isAccessTokenExpiry() {
        return this.accessTokenExpiry != null ? this.accessTokenExpiry : this.evaluateAccessTokenExpiry(false);
    }

    private Boolean evaluateAccessTokenExpiry(boolean immediateOnly) {
        return ELUtils.evaluateBooleanAttribute("accessTokenExpiryExpression", this.logoutDefinition.accessTokenExpiry(), false, this.logoutDefinition.accessTokenExpiryExpression(), immediateOnly);
    }

    public boolean isIdentityTokenExpiry() {
        return this.identityTokenExpiry != null ? this.identityTokenExpiry : this.evaluateIdentityTokenExpiry(false);
    }

    private Boolean evaluateIdentityTokenExpiry(boolean immediateOnly) {
        return ELUtils.evaluateBooleanAttribute("identityTokenExpiryExpression", this.logoutDefinition.identityTokenExpiry(), false, this.logoutDefinition.identityTokenExpiryExpression(), immediateOnly);
    }
}

