/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.filemonitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.filemonitor.FileBasedActionable;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SecurityFileMonitor
implements FileMonitor {
    protected final FileBasedActionable actionable;
    protected final Collection<File> currentlyDeletedFiles;
    static final long serialVersionUID = 3235813105299200616L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SecurityFileMonitor(FileBasedActionable fileBasedActionable) {
        this.actionable = fileBasedActionable;
        this.currentlyDeletedFiles = new HashSet<File>();
    }

    public ServiceRegistration<FileMonitor> monitorFiles(Collection<String> paths, long monitorInterval) {
        BundleContext bundleContext = this.actionable.getBundleContext();
        Hashtable<String, Object> fileMonitorProps = new Hashtable<String, Object>();
        fileMonitorProps.put("monitor.files", paths);
        fileMonitorProps.put("monitor.interval", monitorInterval);
        return bundleContext.registerService(FileMonitor.class, (Object)this, fileMonitorProps);
    }

    public ServiceRegistration<FileMonitor> monitorFiles(Collection<String> paths, long monitorInterval, String updateTrigger) {
        return this.monitorFiles(null, null, paths, monitorInterval, updateTrigger);
    }

    public ServiceRegistration<FileMonitor> monitorFiles(String ID, Collection<String> paths, long pollingRate, String trigger) {
        return this.monitorFiles(ID, null, paths, pollingRate, trigger);
    }

    public ServiceRegistration<FileMonitor> monitorFiles(String ID, Collection<String> dirs, Collection<String> paths, long pollingRate, String trigger) {
        BundleContext bundleContext = this.actionable.getBundleContext();
        Hashtable<String, Object> fileMonitorProps = new Hashtable<String, Object>();
        fileMonitorProps.put("monitor.files", paths);
        if (ID != null && !ID.isEmpty()) {
            fileMonitorProps.put("monitor.identification", "com.ibm.ws.security.monitor.keystore");
            fileMonitorProps.put("monitor.keystore.id", ID);
        }
        if (dirs != null && !dirs.isEmpty()) {
            fileMonitorProps.put("monitor.directories", dirs);
            fileMonitorProps.put("monitor.filter", ".*\\.keys");
        }
        if (!trigger.equalsIgnoreCase("disabled")) {
            if (trigger.equals("mbean")) {
                fileMonitorProps.put("monitor.type", "external");
            } else {
                fileMonitorProps.put("monitor.type", "timed");
                fileMonitorProps.put("monitor.interval", pollingRate);
            }
        }
        if (FrameworkState.isStopping()) {
            return null;
        }
        return bundleContext.registerService(FileMonitor.class, (Object)this, fileMonitorProps);
    }

    public void onBaseline(Collection<File> baseline) {
    }

    public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        HashSet<File> allFiles = new HashSet<File>();
        if (!deletedFiles.isEmpty()) {
            this.currentlyDeletedFiles.addAll(deletedFiles);
            allFiles.addAll(deletedFiles);
        }
        if (this.isActionNeeded(createdFiles, modifiedFiles).booleanValue()) {
            if (!createdFiles.isEmpty()) {
                allFiles.addAll(createdFiles);
            }
            if (!modifiedFiles.isEmpty()) {
                allFiles.addAll(modifiedFiles);
            }
            this.actionable.performFileBasedAction(allFiles);
        }
    }

    private Boolean isActionNeeded(Collection<File> createdFiles, Collection<File> modifiedFiles) {
        boolean actionNeeded = false;
        for (File createdFile : createdFiles) {
            if (!this.currentlyDeletedFiles.contains(createdFile)) continue;
            this.currentlyDeletedFiles.remove(createdFile);
            actionNeeded = true;
        }
        if (!modifiedFiles.isEmpty()) {
            actionNeeded = true;
        }
        return actionNeeded;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.filemonitor.SecurityFileMonitor", SecurityFileMonitor.class, null, null);
    }
}

