/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;

public class WsObjectInputStream
extends ObjectInputStream {
    private static final HashMap primClasses = new HashMap(8, 1.0f);
    protected static ClassResolver resolver;
    protected ClassLoader classloader;
    protected String name;
    PrivilegedExceptionAction loadAction = new PrivilegedExceptionAction(){

        public Object run() throws Exception {
            try {
                Class clazz = null;
                if (resolver != null) {
                    clazz = resolver.resolveClass(WsObjectInputStream.this.name);
                }
                if (clazz == null) {
                    clazz = WsObjectInputStream.this.loadClass(WsObjectInputStream.this.name, WsObjectInputStream.this.classloader);
                }
                return clazz;
            }
            catch (ClassNotFoundException cnf) {
                Class c = (Class)primClasses.get(WsObjectInputStream.this.name);
                if (c != null) {
                    return c;
                }
                throw cnf;
            }
        }
    };
    private Class proxyClass;
    PrivilegedAction proxyClassLoaderAction = new PrivilegedAction(){

        public Object run() {
            return WsObjectInputStream.this.proxyClass.getClassLoader();
        }
    };

    public WsObjectInputStream(InputStream is) throws IOException {
        super(is);
        this.classloader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public WsObjectInputStream(InputStream is, ClassLoader cl) throws IOException {
        super(is);
        this.classloader = cl;
    }

    protected Class resolveClass(ObjectStreamClass objStrmClass) throws IOException, ClassNotFoundException {
        return this.resolveClass(objStrmClass.getName());
    }

    private Class resolveClass(String name) throws IOException, ClassNotFoundException {
        try {
            this.name = name;
            return (Class)AccessController.doPrivileged(this.loadAction);
        }
        catch (PrivilegedActionException pae) {
            Exception wrapped = pae.getException();
            if (wrapped instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)wrapped;
            }
            throw new ClassNotFoundException(name);
        }
    }

    private Class loadClass(String name, ClassLoader loader) throws ClassNotFoundException {
        try {
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException cnf) {
            return Class.forName(name);
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        if (interfaces.length == 0) {
            throw new ClassNotFoundException("zero-length interfaces array");
        }
        Class nonPublicClass = null;
        Class[] classes = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            classes[i] = this.resolveClass(interfaces[i]);
            if ((classes[i].getModifiers() & 1) != 0) continue;
            if (nonPublicClass != null) {
                throw new IllegalAccessError(nonPublicClass + " and " + classes[i] + " both declared non-public");
            }
            nonPublicClass = classes[i];
        }
        this.proxyClass = nonPublicClass != null ? nonPublicClass : classes[0];
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(this.proxyClassLoaderAction);
        try {
            return Proxy.getProxyClass(loader, classes);
        }
        catch (IllegalArgumentException ex) {
            throw new ClassNotFoundException(ex.getMessage(), ex);
        }
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }

    public static interface ClassResolver {
        public Class resolveClass(String var1);
    }
}

