/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.list;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.utils.ras.SibTr;

public class ReadWriteLock {
    private static TraceComponent tc = SibTr.register(ReadWriteLock.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final MutexLock iMutex = new MutexLock();
    private boolean iExclusivelyLocked = false;
    private int iLockCount = 0;
    private int iExclusiveLockCount = 0;
    Thread iExclusiveLockHolder = null;

    public synchronized void lock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"lock", (Object)this);
        }
        boolean interrupted = false;
        while (!this.tryLock()) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Waiting for lock");
                }
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"tryLock", (Object)this);
        }
        boolean result = false;
        MutexLock mutexLock = this.iMutex;
        synchronized (mutexLock) {
            if (!this.iExclusivelyLocked) {
                ++this.iLockCount;
                result = true;
            } else if (this.iExclusiveLockHolder == Thread.currentThread()) {
                result = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"tryLock", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlock() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlock", (Object)this);
        }
        MutexLock mutexLock = this.iMutex;
        synchronized (mutexLock) {
            if (this.iExclusivelyLocked && this.iExclusiveLockHolder == Thread.currentThread()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlock");
                }
                return;
            }
            if (--this.iLockCount == 0) {
                this.notifyAll();
            }
            if (this.iLockCount < 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Unlock caused lock count to drop below zero!");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlock");
                }
                throw new SevereMessageStoreException("Unlock caused lock count to drop below zero!");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlock");
        }
    }

    public synchronized void lockExclusive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"lockExclusive", (Object)this);
        }
        boolean interrupted = false;
        while (!this.tryLockExclusive()) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Waiting to get exclusive lock");
                }
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        while (this.iLockCount > 0) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Waiting for lock count to reach 0 " + this.iLockCount));
                }
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"lockExclusive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLockExclusive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"tryLockExclusive", (Object)this);
        }
        boolean result = false;
        MutexLock mutexLock = this.iMutex;
        synchronized (mutexLock) {
            if (!this.iExclusivelyLocked) {
                this.iExclusivelyLocked = true;
                this.iExclusiveLockHolder = Thread.currentThread();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Got exclusive lock for thread " + this.iExclusiveLockHolder));
                }
                result = true;
                ++this.iExclusiveLockCount;
            } else if (this.iExclusiveLockHolder == Thread.currentThread()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Already hold exclusive lock " + (this.iExclusiveLockCount + 1)));
                }
                result = true;
                ++this.iExclusiveLockCount;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"tryLockExclusive", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlockExclusive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockExclusive", (Object)this);
        }
        MutexLock mutexLock = this.iMutex;
        synchronized (mutexLock) {
            if (Thread.currentThread() == this.iExclusiveLockHolder) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unlocking current thread " + (this.iExclusiveLockCount - 1)));
                }
                if (--this.iExclusiveLockCount == 0) {
                    this.iExclusivelyLocked = false;
                    this.iExclusiveLockHolder = null;
                    this.notifyAll();
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Thread not the current thread to unlock exclusively");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockExclusive");
        }
    }

    private static final class MutexLock {
        private MutexLock() {
        }
    }
}

