/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractObjectStore;
import com.ibm.ws.objectManager.AbstractSetView;
import com.ibm.ws.objectManager.ConcurrentHashMap;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.NonExistentObjectStoreFileException;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.Set;
import com.ibm.ws.objectManager.TemporaryIOException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.WeakValueConcurrentHashMap;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Map;

public final class FileDirObjectStore
extends AbstractObjectStore {
    private static final Class cclass = FileDirObjectStore.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerStore");
    private static final long serialVersionUID = 1767083865060772669L;
    protected static final long headerIdentifier = 101L;
    protected static final long initialSequenceNumber = 200L;
    protected static final int version = 1;
    private transient java.util.Set managedObjectsOnDisk;
    private volatile transient Map managedObjectsToWrite;
    protected transient Map checkpointManagedObjectsToWrite;
    private volatile transient Map tokensToDelete;
    protected transient Map checkpointTokensToDelete;
    String storeDirectoryName;
    private transient Set tokenSet;

    public FileDirObjectStore(String storeName, ObjectManager objectManager) throws ObjectManagerException {
        super(storeName, objectManager, 0);
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{storeName, objectManager});
            trace.exit(this, cclass, "<init>");
        }
    }

    public FileDirObjectStore(String storeName, ObjectManager objectManager, int storeStrategy) throws ObjectManagerException {
        super(storeName, objectManager, storeStrategy);
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{storeName, objectManager, new Integer(storeStrategy)});
            trace.exit(this, cclass, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open(ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "open";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "open", new Object[]{objectManagerState});
        }
        super.open(objectManagerState);
        this.managedObjectsOnDisk = new HashSet();
        this.managedObjectsToWrite = new ConcurrentHashMap(64);
        this.tokensToDelete = new ConcurrentHashMap(64);
        this.storeDirectoryName = (String)objectManagerState.objectStoreLocations.get(this.storeName);
        if (this.storeDirectoryName == null) {
            this.storeDirectoryName = this.storeName;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            trace.debug((Object)this, cclass, "open", new Object[]{"storeName:150", this.storeName, this.storeDirectoryName});
        }
        if (objectManagerState.getObjectManagerStateState() == 2 && !new File(this.storeDirectoryName).exists()) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "open", new Object[]{"File does not exist:159"});
            }
            throw new NonExistentObjectStoreFileException(this, this.storeDirectoryName);
        }
        File storeDirectory = new File(this.storeDirectoryName);
        if (!storeDirectory.isDirectory()) {
            storeDirectory.mkdirs();
        }
        try {
            String storedHeaderFileName = this.storeDirectoryName + File.separator + 101L;
            RandomAccessFile headerFile = new RandomAccessFile(storedHeaderFileName, "r");
            int versionRead = headerFile.readInt();
            long objectStoreIdentifierRead = headerFile.readLong();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "open", new Object[]{new Integer(versionRead), new Long(objectStoreIdentifierRead)});
            }
            if (this.objectStoreIdentifier == -1) {
                this.objectStoreIdentifier = (int)objectStoreIdentifierRead;
            }
            this.sequenceNumber = headerFile.readLong();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "open", new Object[]{new Long(this.sequenceNumber)});
            }
        }
        catch (FileNotFoundException exception) {
            if (Tracing.isAnyTracingEnabled() && trace.isEventEnabled()) {
                trace.event(this, cclass, "java.io.FileNotFoundException caught opening header", exception);
            }
            this.sequenceNumber = 200L;
            this.writeHeader();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "open", exception, "1:212:1.17");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "open");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (this.storeStrategy == 1) {
            this.clear();
        }
        String[] ExistingFiles = storeDirectory.list();
        WeakValueConcurrentHashMap weakValueConcurrentHashMap = this.inMemoryTokens;
        synchronized (weakValueConcurrentHashMap) {
            for (int iFile = 0; iFile < ExistingFiles.length; ++iFile) {
                this.sequenceNumber = Math.max(new Long(ExistingFiles[iFile]), this.sequenceNumber);
                this.managedObjectsOnDisk.add(new Long(ExistingFiles[iFile]));
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "open");
        }
    }

    @Override
    public ManagedObject get(Token storedToken) throws ObjectManagerException {
        String methodName = "get";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "get", new Object[]{storedToken});
        }
        byte[] managedObjectBytes = null;
        try {
            String storedObjectFileName = this.storeDirectoryName + File.separator + storedToken.storedObjectIdentifier;
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "get", new Object[]{storedObjectFileName});
            }
            RandomAccessFile storeFile = new RandomAccessFile(storedObjectFileName, "r");
            long fileLength = storeFile.length();
            managedObjectBytes = new byte[(int)fileLength];
            storeFile.readFully(managedObjectBytes);
            storeFile.close();
        }
        catch (FileNotFoundException exception) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "get", exception);
            }
            return null;
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "get", exception, "1:286:1.17");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "get", exception);
            }
            throw new TemporaryIOException((Object)this, exception);
        }
        ManagedObject objectFromStore = ManagedObject.restoreFromSerializedBytes(managedObjectBytes, this.objectManagerState);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "get", new Object[]{objectFromStore});
        }
        return objectFromStore;
    }

    public void reserve(int deltaSize) throws ObjectManagerException {
    }

    @Override
    public void add(ManagedObject managedObject, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
        String methodName = "add";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "add", new Object[]{managedObject, new Boolean(requiresCurrentCheckpoint)});
        }
        super.add(managedObject, requiresCurrentCheckpoint);
        if (requiresCurrentCheckpoint && this.storeStrategy != 2) {
            if (this.checkpointManagedObjectsToWrite == null) {
                this.captureCheckpointManagedObjects();
            }
            this.checkpointManagedObjectsToWrite.put(new Long(managedObject.owningToken.storedObjectIdentifier), managedObject);
        } else {
            Map myManagedObjectsToWrite;
            do {
                myManagedObjectsToWrite = this.managedObjectsToWrite;
                myManagedObjectsToWrite.put(new Long(managedObject.owningToken.storedObjectIdentifier), managedObject);
            } while (myManagedObjectsToWrite != this.managedObjectsToWrite);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "add");
        }
    }

    @Override
    public void remove(Token token, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "remove", new Object[]{token, new Boolean(requiresCurrentCheckpoint)});
        }
        super.remove(token, requiresCurrentCheckpoint);
        this.managedObjectsToWrite.remove(new Long(token.storedObjectIdentifier));
        if (this.storeStrategy == 2) {
            if (this.managedObjectsOnDisk.contains(new Long(token.storedObjectIdentifier))) {
                this.tokensToDelete.put(new Long(token.storedObjectIdentifier), token);
            }
        } else if (requiresCurrentCheckpoint) {
            if (this.checkpointTokensToDelete == null) {
                this.captureCheckpointManagedObjects();
            }
            this.checkpointTokensToDelete.put(new Long(token.storedObjectIdentifier), token);
        } else {
            Map myTokensToDelete;
            do {
                myTokensToDelete = this.tokensToDelete;
                myTokensToDelete.put(new Long(token.storedObjectIdentifier), token);
            } while (myTokensToDelete != this.tokensToDelete);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "remove");
        }
    }

    synchronized void captureCheckpointManagedObjects() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "captureCheckpointManagedObjectsremove");
        }
        if (this.checkpointManagedObjectsToWrite == null) {
            this.checkpointManagedObjectsToWrite = this.managedObjectsToWrite;
            this.managedObjectsToWrite = new ConcurrentHashMap(64);
            this.checkpointTokensToDelete = this.tokensToDelete;
            this.tokensToDelete = new ConcurrentHashMap(64);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "captureCheckpointManagedObjects");
        }
    }

    @Override
    protected synchronized void clear() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "clear");
        }
        super.clear();
        this.managedObjectsOnDisk = new HashSet();
        this.managedObjectsToWrite = new ConcurrentHashMap(64);
        this.tokensToDelete = new ConcurrentHashMap(64);
        this.deleteDirectory(this.storeDirectoryName);
        File storeDirectory = new File(this.storeDirectoryName);
        if (!storeDirectory.isDirectory()) {
            storeDirectory.mkdirs();
        }
        this.sequenceNumber = 200L;
        this.writeHeader();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "clear");
        }
    }

    @Override
    public synchronized void flush() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "flush");
        }
        Map ourManagedObjectsToWrite = this.managedObjectsToWrite;
        this.managedObjectsToWrite = new ConcurrentHashMap(64);
        Map ourTokensToDelete = this.tokensToDelete;
        this.tokensToDelete = new ConcurrentHashMap(64);
        for (ManagedObject managedObject : ourManagedObjectsToWrite.values()) {
            this.write(managedObject);
        }
        for (Token token : ourTokensToDelete.values()) {
            if (!this.managedObjectsOnDisk.contains(new Long(token.storedObjectIdentifier))) continue;
            File storeFile = new File(this.storeDirectoryName + File.separator + token.storedObjectIdentifier);
            storeFile.delete();
            this.managedObjectsOnDisk.remove(new Long(token.storedObjectIdentifier));
        }
        this.writeHeader();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "flush");
        }
    }

    @Override
    public Set tokens() {
        if (this.tokenSet == null) {
            this.tokenSet = new AbstractSetView(){

                @Override
                public long size() {
                    return FileDirObjectStore.this.managedObjectsOnDisk.size();
                }

                @Override
                public Iterator iterator() {
                    final java.util.Iterator tokenIterator = FileDirObjectStore.this.managedObjectsOnDisk.iterator();
                    return new Iterator(){

                        @Override
                        public boolean hasNext() {
                            return tokenIterator.hasNext();
                        }

                        @Override
                        public Object next() {
                            Token token = new Token(FileDirObjectStore.this, (Long)tokenIterator.next());
                            return FileDirObjectStore.this.like(token);
                        }

                        @Override
                        public boolean hasNext(Transaction transaction) throws ObjectManagerException {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Object next(Transaction transaction) throws ObjectManagerException {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Object remove(Transaction transaction) throws ObjectManagerException {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        return this.tokenSet;
    }

    private void write(ManagedObject managedObject) throws ObjectManagerException {
        String methodName = "write";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "write", new Object[]{managedObject});
        }
        ObjectManagerByteArrayOutputStream serializedBytes = null;
        if (this.usesSerializedForm) {
            if (managedObject.state != 7) {
                serializedBytes = managedObject.freeLatestSerializedBytes();
            }
        } else if (managedObject.state == 8) {
            serializedBytes = managedObject.getSerializedBytes();
        }
        if (serializedBytes != null) {
            try {
                FileOutputStream storeFileOutputStream = new FileOutputStream(this.storeDirectoryName + File.separator + managedObject.owningToken.storedObjectIdentifier);
                storeFileOutputStream.write(serializedBytes.getBuffer(), 0, serializedBytes.getCount());
                storeFileOutputStream.flush();
                storeFileOutputStream.close();
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "write", exception, "1:656:1.17");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "write", new Object[]{exception});
                }
                throw new PermanentIOException((Object)this, exception);
            }
            this.managedObjectsOnDisk.add(new Long(managedObject.owningToken.storedObjectIdentifier));
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "write");
        }
    }

    public void writeHeader() throws ObjectManagerException {
        String methodName = "writeHeader";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "writeHeader");
        }
        try {
            FileOutputStream headerOutputStream = new FileOutputStream(this.storeDirectoryName + File.separator + 101L);
            DataOutputStream dataOutputStream = new DataOutputStream(headerOutputStream);
            FileDescriptor fileDescriptor = headerOutputStream.getFD();
            dataOutputStream.writeInt(1);
            dataOutputStream.writeLong(this.objectStoreIdentifier);
            dataOutputStream.writeLong(this.sequenceNumber);
            dataOutputStream.flush();
            headerOutputStream.flush();
            fileDescriptor.sync();
            headerOutputStream.close();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeHeader", exception, "1:706:1.17");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "writeHeader", new Object[]{exception});
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeHeader");
        }
    }

    public void deleteDirectory(String directoryName) {
        File file = new File(directoryName);
        this.doDelete(file);
    }

    private void doDelete(File file) {
        if (file.isDirectory()) {
            int iFile;
            String[] files = file.list();
            File[] nextFiles = null;
            if (files != null) {
                nextFiles = new File[files.length];
                for (iFile = 0; iFile < nextFiles.length; ++iFile) {
                    nextFiles[iFile] = new File(file.getPath(), files[iFile]);
                }
            }
            if (nextFiles != null) {
                for (iFile = 0; iFile < nextFiles.length; ++iFile) {
                    File nextFile = nextFiles[iFile];
                    if (nextFile.isDirectory()) {
                        this.doDelete(nextFile);
                        continue;
                    }
                    nextFile.delete();
                }
            }
        }
        file.delete();
    }
}

