/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractObjectStore;
import com.ibm.ws.objectManager.AbstractSetView;
import com.ibm.ws.objectManager.InMemoryObjectNotAvailableException;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.Set;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.util.Map;
import java.util.NoSuchElementException;

public final class DummyFileObjectStore
extends AbstractObjectStore {
    private static final Class cclass = DummyFileObjectStore.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerStore");
    private static final long serialVersionUID = 4029554983273984385L;
    private transient Set tokenSet;

    public DummyFileObjectStore(String storeName, ObjectManager objectManager) throws ObjectManagerException {
        super(storeName, objectManager, 0);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", "StoreName=" + storeName + ", ObjectManager=" + objectManager);
            trace.exit(this, cclass, "<init>");
        }
    }

    protected DummyFileObjectStore(ObjectManagerState objectManagerState) throws ObjectManagerException {
        super(objectManagerState);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", objectManagerState);
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    public ManagedObject get(Token token) throws ObjectManagerException {
        String methodName = "get";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "get", token);
            trace.exit(this, cclass, "get");
        }
        throw new InMemoryObjectNotAvailableException(this, token);
    }

    @Override
    public synchronized void flush() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "flush");
            trace.exit(this, cclass, "flush");
        }
    }

    @Override
    public Set tokens() {
        if (this.tokenSet == null) {
            this.tokenSet = new AbstractSetView(){

                @Override
                public long size() {
                    return 0L;
                }

                @Override
                public Iterator iterator() {
                    return new Iterator(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public Object next() {
                            throw new NoSuchElementException();
                        }

                        @Override
                        public boolean hasNext(Transaction transaction) throws ObjectManagerException {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Object next(Transaction transaction) throws ObjectManagerException {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Object remove(Transaction transaction) throws ObjectManagerException {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        return this.tokenSet;
    }

    @Override
    public Map captureStatistics() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "captureStatistics");
        }
        Map statistics = super.captureStatistics();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "captureStatistics", "return statistics=" + statistics);
        }
        return statistics;
    }
}

