/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractCollection;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.List;
import com.ibm.ws.objectManager.ListIterator;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.Set;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.PrintStream;
import java.util.NoSuchElementException;

public abstract class AbstractList
extends AbstractCollection
implements List {
    private static final Class cclass = AbstractList.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(AbstractList.class, "ObjectManagerLists");

    protected AbstractList() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "<init>");
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    public boolean add(Token token, Transaction transaction) throws ObjectManagerException {
        List.Entry entry = this.addEntry(token, transaction);
        return entry != null;
    }

    public List.Entry addEntry(Object object, Transaction transaction) throws ObjectManagerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Token getFirst(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getFirst", new Object[]{transaction});
        }
        Token first = (Token)this.iterator().next(transaction);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getFirst", new Object[]{first});
        }
        return first;
    }

    @Override
    public Token removeFirst(Transaction transaction) throws ObjectManagerException {
        Iterator iterator = this.entrySet().iterator();
        List.Entry entry = (List.Entry)iterator.next(transaction);
        iterator.remove(transaction);
        return entry.getValue();
    }

    public Object set(long index, Object element, Transaction transaction) throws ObjectManagerException {
        throw new UnsupportedOperationException();
    }

    public Object remove(long index, Transaction transaction) throws ObjectManagerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long indexOf(Token token, Transaction transaction) throws ObjectManagerException {
        long index;
        try {
            Iterator iterator = this.iterator();
            for (index = 0L; index < Long.MAX_VALUE && iterator.next(transaction) != token; ++index) {
            }
        }
        catch (NoSuchElementException exception) {
            index = -1L;
        }
        return index;
    }

    @Override
    public long lastIndexOf(Token token, Transaction transaction) throws ObjectManagerException {
        long index;
        long lastIndex = -1L;
        try {
            Iterator iterator = this.iterator();
            for (index = 0L; index < Long.MAX_VALUE; ++index) {
                if (iterator.next(transaction) != token) continue;
                lastIndex = index;
            }
        }
        catch (NoSuchElementException exception) {
            index = -1L;
        }
        return lastIndex;
    }

    @Override
    public abstract Iterator iterator() throws ObjectManagerException;

    @Override
    public ListIterator listIterator() throws ObjectManagerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator listIterator(long index, Transaction transaction) throws ObjectManagerException {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        ListIterator listIterator = this.listIterator();
        try {
            for (long i = 0L; i < index; ++i) {
                listIterator.next(transaction);
            }
        }
        catch (NoSuchElementException exception) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return listIterator;
    }

    @Override
    public List subList(List.Entry fromEntry, List.Entry toEntry) throws ObjectManagerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean validate(PrintStream printStream) throws ObjectManagerException {
        throw new UnsupportedOperationException();
    }
}

