/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.authentication;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.exceptions.AuthenticationResponseException;
import io.openliberty.security.oidcclientcore.exceptions.StateTimestampException;
import io.openliberty.security.oidcclientcore.storage.OidcStorageUtils;
import io.openliberty.security.oidcclientcore.storage.Storage;
import io.openliberty.security.oidcclientcore.utils.Utils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Date;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AuthenticationResponseValidator {
    public static final TraceComponent tc = Tr.register(AuthenticationResponseValidator.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    public static final int STORED_STATE_VALUE_LENGTH = 24;
    protected final HttpServletRequest request;
    protected final HttpServletResponse response;
    protected Storage storage;
    static final long serialVersionUID = -4745751026293688932L;

    public AuthenticationResponseValidator(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public abstract void validateResponse() throws AuthenticationResponseException;

    protected abstract String getStoredStateValue(String var1) throws AuthenticationResponseException;

    @FFDCIgnore(value={StateTimestampException.class})
    public void verifyState(String stateParameter, String clientId, @Sensitive String clientSecret, long clockSkewInSeconds, long authenticationTimeLimitInSeconds) throws AuthenticationResponseException {
        if (stateParameter.length() < 24) {
            String nlsMessage = Tr.formatMessage((TraceComponent)tc, (String)"STATE_VALUE_IN_CALLBACK_INCORRECT_LENGTH", (Object[])new Object[]{stateParameter, 24});
            throw new AuthenticationResponseException(AuthenticationResponseException.ValidationResult.INVALID_RESULT, clientId, nlsMessage);
        }
        String storedStateValue = this.getStoredStateValue(stateParameter);
        String expectedStateValue = OidcStorageUtils.createStateStorageValue(stateParameter, clientSecret);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("storedStateValue:'" + storedStateValue + "' expectedStateValue:'" + expectedStateValue + "'"), (Object[])new Object[0]);
        }
        if (expectedStateValue.equals(storedStateValue)) {
            try {
                this.verifyStateTimestampWithinClockSkew(stateParameter, clockSkewInSeconds, authenticationTimeLimitInSeconds);
            }
            catch (StateTimestampException e) {
                throw new AuthenticationResponseException(AuthenticationResponseException.ValidationResult.INVALID_RESULT, clientId, e.getMessage());
            }
        } else {
            String nlsMessage = Tr.formatMessage((TraceComponent)tc, (String)"STATE_VALUE_IN_CALLBACK_DOES_NOT_MATCH_STORED_VALUE", (Object[])new Object[]{stateParameter});
            throw new AuthenticationResponseException(AuthenticationResponseException.ValidationResult.INVALID_RESULT, clientId, nlsMessage);
        }
    }

    void verifyStateTimestampWithinClockSkew(String responseState, long clockSkewInSeconds, long authenticationTimeLimitInSeconds) throws StateTimestampException {
        long clockSkewMillSeconds = clockSkewInSeconds * 1000L;
        long timestampFromStateValue = Utils.convertNormalizedTimeStampToLong(responseState);
        long currentTime = new Date().getTime();
        long minDate = timestampFromStateValue - clockSkewMillSeconds;
        long maxDate = timestampFromStateValue + clockSkewMillSeconds + authenticationTimeLimitInSeconds * 1000L;
        if (minDate >= currentTime || currentTime >= maxDate) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("error current: " + currentTime + "  ran at:" + timestampFromStateValue), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("current time must be between " + minDate + " and " + maxDate), (Object[])new Object[0]);
            }
            throw new StateTimestampException(responseState, currentTime, minDate, maxDate);
        }
    }
}

