/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.SessionData;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.IProtocolAdapter;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.ISessionAffinityManager;
import com.ibm.wsspi.session.IStore;
import com.ibm.wsspi.session.SessionAffinityContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import java.util.logging.Level;

public class SessionAffinityManager
implements ISessionAffinityManager {
    private static final String methodClassName = "SessionAffinityManager";
    protected String _cloneID = "";
    private final String _versionPrefix = "0000";
    protected int _versionPrefixLength = 4;
    protected int _versionPlusIdLength;
    protected SessionManagerConfig _smc;
    protected SessionContext _sessCtx;
    protected IStore _store;
    protected String whichCookie = "";
    protected static final int GET_REQUESTED_SESSION_ID_FROM_URL = 0;
    protected static final int ANALYZE_REQUEST = 1;
    protected static final int SET_NEXT_ID = 2;
    protected static final int ENCODE_URL = 3;
    protected static final int SET_COOKIE = 4;
    protected static final int SET_SIP_COOKIE = 5;
    protected static final int ANALYZE_SSL_REQUEST = 6;
    private static final int UPDATE_CLONE_INFO = 7;
    protected static final String[] methodNames = new String[]{"getRequestedSessionIdFromURL", "analyzeRequest", "setNextId", "encodeURL", "setCookie", "setSIPCookie", "analyzeSSLRequest", "UpdateCloneInfo"};
    static final String[] unSecStrs = new String[]{"<", ">", "&", "!", "'", "(", ")", "\""};

    public SessionAffinityManager(SessionManagerConfig smc, SessionContext sessCtx, IStore store) {
        this._smc = smc;
        this._sessCtx = sessCtx;
        this._store = store;
        this._versionPlusIdLength = this._versionPrefixLength + SessionManagerConfig.getSessionIDLength();
    }

    public String getRequestedSessionIdFromURL(ServletRequest request) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[0]);
        }
        Object sessionID = null;
        return null;
    }

    @Override
    public List getAllCookieValues(ServletRequest request) {
        return null;
    }

    @Override
    public SessionAffinityContext analyzeRequest(ServletRequest request) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "");
        }
        return null;
    }

    @Override
    public boolean setNextId(SessionAffinityContext sac) {
        List allSessionIds;
        boolean rc = false;
        String versionString = "";
        String id = null;
        String cloneInfo = "";
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[2]);
        }
        if ((allSessionIds = sac.getAllSessionIds()) != null && !allSessionIds.isEmpty() && !sac.isResponseIdSet()) {
            String nextId = (String)allSessionIds.remove(0);
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[2], "Next id is " + (nextId != null ? nextId : "Null"));
            }
            if (sac.isFirstSessionIdValid()) {
                if (nextId != null && (nextId.length() >= this._versionPlusIdLength || this._smc.useSSLId())) {
                    int expectedIdLength;
                    int idLength;
                    int index;
                    block19: {
                        rc = true;
                        sac.setRequestedVersion(0);
                        if (this._versionPrefixLength > 0) {
                            versionString = nextId.substring(0, this._versionPrefixLength);
                            try {
                                int sessionVersion = Integer.parseInt(versionString);
                                sac.setRequestedVersion(sessionVersion);
                            }
                            catch (NumberFormatException e) {
                                if (!isTraceOn || !LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) break block19;
                                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[2], "Caught exception when parsing JSessionID in cookie:", e);
                            }
                        }
                    }
                    if ((index = nextId.indexOf(SessionManagerConfig.getCloneSeparator())) == -1) {
                        id = nextId.substring(this._versionPrefixLength);
                    } else if (index < this._versionPrefixLength) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, methodNames[2], "Symbol(:) exception caught in JSessionID, setting: " + id + " to null.");
                        id = null;
                    } else {
                        cloneInfo = nextId.substring(index);
                        id = nextId.substring(this._versionPrefixLength, index);
                    }
                    if (id != null && (idLength = id.length()) > (expectedIdLength = SessionManagerConfig.getSessionIDLength())) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, methodNames[2], "Detected JSESSIONID with invalid length; expected length of " + expectedIdLength + ", found " + idLength + ", setting: " + id + " to null.");
                        id = null;
                    }
                    sac.setRequestedSessionID(id);
                    if (SessionManagerConfig.isCloneIdPropertySet() && SessionManagerConfig.isExpectedCloneIdsPropertySet() && index > 0) {
                        String cloneSeparatorAsString = String.valueOf(SessionManagerConfig.getCloneSeparator());
                        String[] cloneIds = cloneInfo.split(cloneSeparatorAsString);
                        for (int i = 0; i < cloneIds.length; ++i) {
                            if (cloneIds[i].length() <= 0 || SessionManagerConfig.getExpectedCloneIds().contains(cloneIds[i])) continue;
                            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, methodNames[2], "Detected suspicious cloneId associated with the incoming request. The list of incoming cloneIds " + cloneInfo + " is no longer valid and will be cleared.");
                            cloneInfo = "";
                            break;
                        }
                    }
                    sac.setInputCloneInfo(cloneInfo);
                    if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        StringBuffer sb = new StringBuffer("Version:").append(versionString).append(":Id:").append(id).append(":CloneInfo:").append(cloneInfo);
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[2], sb.toString());
                    }
                } else if (nextId != null && nextId.length() < this._versionPlusIdLength) {
                    sac.setFirstSessionIdValid(false);
                }
            }
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[2], rc);
        }
        return rc;
    }

    private static boolean isSafe(String id) {
        for (int i = 0; i < unSecStrs.length; ++i) {
            if (id.indexOf(unSecStrs[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public String encodeURL(HttpSession session, String url) {
        return this.encodeURL(session, null, url, null);
    }

    private String encodeURL(HttpSession sessForSip, ServletRequest request, String uri, SessionAffinityContext affinityContext) {
        String sessionVersionString;
        String sessIdOnly;
        if (affinityContext != null) {
            int sessionVersion = affinityContext.getResponseSessionVersion();
            sessIdOnly = affinityContext.getResponseSessionID();
            sessionVersionString = this.getVersionString(sessionVersion);
        } else {
            ISession isess = ((SessionData)sessForSip).getISession();
            sessIdOnly = isess.getId();
            sessionVersionString = this.getVersionString(isess.getVersion());
        }
        String sessionID = sessionVersionString.concat(sessIdOnly);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[3]);
        }
        if (!SessionAffinityManager.isSafe(sessionID)) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3], "URL is not safe");
            }
            return uri;
        }
        int postStart = -1;
        int preEnd = uri.indexOf(this._smc.getSessUrlRewritePrefix());
        if (preEnd != -1) {
            postStart = uri.indexOf(";", preEnd + 1);
        }
        if (postStart == -1) {
            int i = uri.indexOf("?");
            int j = uri.indexOf("#");
            if (i != -1 && j != -1 && j < i) {
                i = j;
            }
            if (i == -1 && j != -1) {
                i = j;
            }
            postStart = i;
        }
        if (preEnd == -1) {
            preEnd = postStart;
        }
        String pre = null;
        String post = null;
        StringBuffer sb = null;
        if (preEnd != -1) {
            pre = uri.substring(0, preEnd);
            sb = new StringBuffer(pre);
            if (postStart != -1) {
                post = uri.substring(postStart, uri.length());
            }
        } else {
            sb = new StringBuffer(uri);
        }
        sb.append(this._smc.getSessUrlRewritePrefix());
        sb.append(sessionID);
        String cloneSeparatorPlusID = this.getSeparatorPlusAffinityToken(sessIdOnly);
        if (affinityContext != null) {
            String cloneInfo = this.updateCloneInfo(affinityContext, cloneSeparatorPlusID);
            if (!SessionAffinityManager.isSafe(cloneInfo)) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3], "AffinityContext cloneID is not safe");
                }
                return uri;
            }
            sb.append(cloneInfo);
        } else {
            if (!SessionAffinityManager.isSafe(cloneSeparatorPlusID)) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3], "CloneID in URL is not safe");
                }
                return uri;
            }
            sb.append(cloneSeparatorPlusID);
        }
        if (sb.length() > SessionManagerConfig.getMaxSessionIdentifierLength() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.WARNING)) {
            Object[] parms = new String[]{sb.toString(), new Integer(SessionManagerConfig.getMaxSessionIdentifierLength()).toString()};
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, methodNames[3], "SessionContext.maxSessionIdLengthExceeded", parms);
        }
        if (postStart != -1) {
            sb.append(post);
        }
        uri = sb.toString();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3], uri);
        }
        return uri;
    }

    @Override
    public String encodeURL(ServletRequest request, String uri, SessionAffinityContext affinityContext) {
        return this.encodeURL(null, request, uri, affinityContext);
    }

    @Override
    public void setCookie(ServletRequest request, ServletResponse response, SessionAffinityContext affinityContext, Object session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[4], "");
        }
    }

    public void setSIPCookie(ServletRequest request, ServletResponse response, String sipCookieString) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[5], "");
        }
    }

    protected String getVersionString(int sessionVersion) {
        String sessionVersionString = "0000";
        if (this._versionPrefixLength > 0) {
            if (sessionVersion > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append("0000").append(sessionVersion);
                sessionVersionString = sb.substring(sb.length() - this._versionPrefixLength, sb.length());
            }
        } else {
            sessionVersionString = "";
        }
        return sessionVersionString;
    }

    protected String getSeparatorPlusAffinityToken(String sessId) {
        StringBuffer separatorPlusAffToken = new StringBuffer();
        String affToken = this._store.getAffinityToken(sessId, this._sessCtx.getAppName());
        if (affToken == null) {
            affToken = this._cloneID;
        }
        if (affToken != null && affToken.length() > 0) {
            separatorPlusAffToken.append(SessionManagerConfig.getCloneSeparator()).append(affToken);
        }
        return separatorPlusAffToken.toString();
    }

    protected String updateCloneInfo(SessionAffinityContext sac, String thisClone) {
        int index;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        String cloneString = sac.isOutputCloneInfoSet() ? sac.getOutputCloneInfo() : sac.getInputCloneInfo();
        String incomingSessId = sac.getRequestedSessionID();
        String outgoingSessId = sac.getResponseSessionID();
        if (outgoingSessId != null && !outgoingSessId.equals(incomingSessId)) {
            sac.setInputCloneInfo("");
            cloneString = thisClone;
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[7], "Setting cloneID:" + cloneString + ":");
            }
        }
        if ((index = cloneString.indexOf(thisClone)) == -1) {
            StringBuffer newClones = new StringBuffer();
            if (SessionManagerConfig.isNoAffinitySwitchBack()) {
                newClones.append(thisClone).append(cloneString);
            } else {
                newClones.append(cloneString).append(thisClone);
            }
            cloneString = newClones.toString();
            sac.setOutputCloneInfo(cloneString);
        } else if (SessionManagerConfig.isNoAffinitySwitchBack() && index > 0) {
            cloneString = thisClone + cloneString.substring(0, index) + cloneString.substring(index + thisClone.length());
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[7], "New cloneString : " + cloneString + ".");
            }
        }
        return cloneString;
    }

    @Override
    public String getInUseSessionID(ServletRequest req, SessionAffinityContext sac) {
        String id = null;
        if (sac.isRequestedSessionIDFromSSL() && req != null) {
            id = this.getActualSSLSessionId(req);
        } else {
            id = sac.getResponseSessionID();
            if (id == null) {
                id = sac.getRequestedSessionID();
            }
        }
        return id;
    }

    @Override
    public int getInUseSessionVersion(ServletRequest req, SessionAffinityContext sac) {
        int version = sac.getResponseSessionVersion();
        if (version == -1) {
            version = sac.getRequestedSessionVersion();
        }
        return version;
    }

    public String getActualSSLSessionId(ServletRequest request) {
        return null;
    }

    public SessionAffinityContext analyzeSSLRequest(ServletRequest request, String sslSessionId) {
        return null;
    }

    public void setSessionId(HttpServletRequest _request, SessionAffinityContext sac) {
    }

    public void setResponseData(String idFromRequest, SessionAffinityContext sac) {
    }

    public String getCloneId() {
        return this._cloneID;
    }

    @Override
    public String encodeURL(ServletRequest request, String url, SessionAffinityContext affinityContext, IProtocolAdapter adapter) {
        return null;
    }

    @Override
    public String getLocalCloneID() {
        return null;
    }

    @Override
    public void setCookie(ServletRequest request, ServletResponse response, SessionAffinityContext affinityContext, IProtocolAdapter adapter, Object session) {
    }

    @Override
    public void setCookieName(String cookieName) {
    }

    @Override
    public void setUseURLEncoding(boolean useURLEncoding) {
    }
}

