/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.jmx.internal;

import com.ibm.ws.kernel.boot.jmx.internal.PlatformMBeanServer;
import com.ibm.ws.kernel.boot.jmx.internal.PlatformMBeanServerBuilderListener;
import com.ibm.ws.kernel.boot.jmx.internal.PlatformMBeanServerDelegate;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;

public final class PlatformMBeanServerBuilder
extends MBeanServerBuilder {
    private static final ConcurrentLinkedQueue<PlatformMBeanServerBuilderListener> listenerQueue = new ConcurrentLinkedQueue();
    private static volatile PlatformMBeanServer platformMBeanServer;
    private static volatile boolean loading;

    @Override
    public MBeanServer newMBeanServer(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        if (loading && PlatformMBeanServerBuilder.isCreatingPlatformMBeanServer(2)) {
            return platformMBeanServer;
        }
        MBeanServer mbs = super.newMBeanServer(defaultDomain, outer, delegate);
        PlatformMBeanServer pmbs = new PlatformMBeanServer(mbs, (PlatformMBeanServerDelegate)delegate);
        if (!loading && platformMBeanServer == null && PlatformMBeanServerBuilder.isCreatingPlatformMBeanServer(1)) {
            platformMBeanServer = pmbs;
            loading = true;
            PlatformMBeanServerBuilder.notifyListeners();
            loading = false;
        }
        return pmbs;
    }

    @Override
    public MBeanServerDelegate newMBeanServerDelegate() {
        return new PlatformMBeanServerDelegate();
    }

    public static void addPlatformMBeanServerBuilderListener(PlatformMBeanServerBuilderListener listener) {
        PlatformMBeanServer mbs = platformMBeanServer;
        if (mbs != null) {
            mbs.invokePlatformMBeanServerCreated(listener);
        } else {
            listenerQueue.add(listener);
            if (platformMBeanServer != null) {
                PlatformMBeanServerBuilder.notifyListeners();
            }
        }
    }

    private static boolean isCreatingPlatformMBeanServer(int threshold) {
        int count = 0;
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (!"java.lang.management.ManagementFactory".equals(ste.getClassName()) || !"getPlatformMBeanServer".equals(ste.getMethodName()) || ++count < threshold) continue;
            return true;
        }
        return false;
    }

    private static void notifyListeners() {
        PlatformMBeanServer mbs = platformMBeanServer;
        PlatformMBeanServerBuilderListener listener = listenerQueue.poll();
        while (listener != null) {
            mbs.invokePlatformMBeanServerCreated(listener);
            listener = listenerQueue.poll();
        }
    }

    static {
        loading = false;
    }
}

