/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.tcpchannel.internal.ChannelSelector;
import com.ibm.ws.tcpchannel.internal.NioSocketIOChannel;
import com.ibm.ws.tcpchannel.internal.NioTCPChannel;
import com.ibm.ws.tcpchannel.internal.SimpleSync;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;
import java.net.SocketAddress;

public class NioTCPReadRequestContextImpl
extends TCPReadRequestContextImpl {
    private static final TraceComponent tc = Tr.register(NioTCPReadRequestContextImpl.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    public NioTCPReadRequestContextImpl(TCPConnLink link) {
        super(link);
    }

    @Override
    public long processSyncReadRequest(long numBytes, int timeout) throws IOException {
        long bytesRead = 0L;
        if (numBytes != 0L) {
            if (this.blockWait == null) {
                this.blockWait = new SimpleSync();
            }
            this.blockingIOError = null;
            this.blockedThread = true;
            VirtualConnection vc = this.readInternal(numBytes, null, false, timeout);
            while (vc == null) {
                this.blockWait.simpleWait();
                if (this.blockingIOError != null) break;
                vc = ((NioTCPChannel)this.getTCPConnLink().getTCPChannel()).getWorkQueueManager().processWork(this, 1);
            }
            this.blockedThread = false;
            if (this.blockingIOError != null) {
                throw this.blockingIOError;
            }
            bytesRead = this.getIOCompleteAmount();
        } else {
            this.setJITAllocateAction(false);
            if (this.getJITAllocateSize() > 0 && this.getBuffers() == null) {
                if (this.getConfig().getAllocateBuffersDirect()) {
                    this.setBuffer(ChannelFrameworkFactory.getBufferManager().allocateDirect(this.getJITAllocateSize()));
                } else {
                    this.setBuffer(ChannelFrameworkFactory.getBufferManager().allocate(this.getJITAllocateSize()));
                }
                this.setJITAllocateAction(true);
            }
            WsByteBuffer[] wsBuffArray = this.getBuffers();
            NioSocketIOChannel channel = (NioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel();
            bytesRead = wsBuffArray.length == 1 ? (long)channel.read(wsBuffArray[0].getWrappedByteBufferNonSafe()) : channel.read(this.getByteBufferArray());
            if (bytesRead < 0L) {
                if (this.getJITAllocateAction()) {
                    this.getBuffer().release();
                    this.setBuffer(null);
                    this.setJITAllocateAction(false);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Sync read throwing IOException", (Object[])new Object[0]);
                }
                String s = "Read failed.  End of data reached.";
                try {
                    SocketAddress iaLocal = this.getTCPConnLink().getSocketIOChannel().getSocket().getLocalSocketAddress();
                    SocketAddress iaRemote = this.getTCPConnLink().getSocketIOChannel().getSocket().getRemoteSocketAddress();
                    s = s + " local=" + iaLocal + " remote=" + iaRemote;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new IOException(s);
            }
        }
        return bytesRead;
    }

    @Override
    public VirtualConnection processAsyncReadRequest() {
        return ((NioTCPChannel)this.getTCPConnLink().getTCPChannel()).getWorkQueueManager().processWork(this, 0);
    }

    @Override
    protected void immediateTimeout() {
        ChannelSelector sel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"immediateTimeout", (Object[])new Object[0]);
        }
        if (null != (sel = ((NioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).getChannelSelectorRead())) {
            this.timeoutTime = System.currentTimeMillis() - 2000L;
            sel.resetTimeout(this.timeoutTime);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"No read selector, ignoring immediate timeout", (Object[])new Object[0]);
        }
    }
}

