/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collector.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.collector.internal.TaskConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TaskConfig {
    private final String location;
    private final String sourceName;
    private final boolean enabled;
    private final String[] tags;
    private final int maxFieldLength;
    private final int maxEvents;
    static final long serialVersionUID = -3442942435958250526L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private TaskConfig(Builder builder) {
        this.location = builder.location;
        this.sourceName = builder.source;
        this.enabled = builder.enabled;
        this.tags = builder.tags;
        this.maxFieldLength = builder.maxFieldLength;
        this.maxEvents = builder.maxEvents;
    }

    public String sourceId() {
        return this.sourceName + "|" + this.location;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String[] getTags() {
        return this.tags != null ? Arrays.copyOf(this.tags, this.tags.length) : null;
    }

    public int getMaxEvents() {
        return this.maxEvents;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public String toString() {
        return "TaskConfig [location=" + this.location + ", sourceName=" + this.sourceName + ", enabled=" + this.enabled + ", tags=" + (this.tags != null ? Arrays.toString(this.tags) : this.tags) + ", maxFieldLength=" + this.maxFieldLength + ", maxEvents=" + this.maxEvents + "]";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.collector.internal.TaskConfig", TaskConfig.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Builder {
        private final String location;
        private final String source;
        private boolean enabled = TaskConstants.DEFAULT_TASK_STATUS;
        private String[] tags;
        private int maxFieldLength;
        private int maxEvents;
        static final long serialVersionUID = -5807162207954917464L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Builder(String source, String location) {
            this.source = source;
            this.location = location;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public TaskConfig build() {
            return new TaskConfig(this);
        }

        public Builder tags(String[] tags) {
            if (tags != null) {
                this.tags = Arrays.copyOf(tags, tags.length);
            }
            return this;
        }

        public Builder maxEvents(int maxEvents) {
            this.maxEvents = maxEvents;
            return this;
        }

        public Builder maxFieldLength(int maxFieldLength) {
            this.maxFieldLength = maxFieldLength;
            return this;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collector.internal.TaskConfig$Builder", Builder.class, null, null);
        }
    }
}

