/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS.providers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.spi.JsonProvider;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Scanner;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@Produces(value={"application/json", "application/*+json"})
@Consumes(value={"application/json", "application/*+json"})
@Provider
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class JsonPProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    final JsonProvider jsonProvider = AccessController.doPrivileged(new PrivilegedAction<JsonProvider>(){
        static final long serialVersionUID = -7856987986333636070L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public JsonProvider run() {
            try {
                BundleContext bc;
                ServiceReference sr;
                Bundle b = FrameworkUtil.getBundle(JsonPProvider.class);
                if (b != null && (sr = (bc = b.getBundleContext()).getServiceReference(JsonProvider.class)) != null) {
                    return (JsonProvider)bc.getService(sr);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return JsonProvider.provider();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS.providers.JsonPProvider$1", 1.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
        }
    });
    static final long serialVersionUID = 7526057054856707367L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonValue.class.isAssignableFrom(type) || type.isPrimitive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Object obj, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (entityStream == null) {
            throw new IOException("Initialized OutputStream should be provided");
        }
        JsonWriter writer = null;
        try {
            writer = this.jsonProvider.createWriter(entityStream);
            if (writer != null) {
                writer.write((JsonValue)obj);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonValue.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type);
    }

    @FFDCIgnore(value={Throwable.class})
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        block20: {
            JsonStructure jsonStructure;
            if (entityStream == null) {
                throw new IOException("Initialized InputStream should be provided");
            }
            if (type.equals(JsonNumber.class) || Number.class.isAssignableFrom(type)) {
                return this.castNumber(entityStream, type);
            }
            JsonReader reader = null;
            try {
                reader = this.jsonProvider.createReader(entityStream);
                if (reader == null) break block20;
                if (JsonString.class.isAssignableFrom(type)) {
                    JsonValue jsonValue = reader.readValue();
                    return jsonValue;
                }
                jsonStructure = reader.read();
            }
            catch (Throwable e) {
                if (JsonException.class.isAssignableFrom(e.getClass())) {
                    throw new BadRequestException(e);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new WebApplicationException(e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            return jsonStructure;
        }
        return null;
    }

    private <T> T castNumber(InputStream in, Class<T> type) throws IOException {
        String str;
        try (Scanner s = new Scanner(in).useDelimiter("\\A");){
            StringBuilder sb = new StringBuilder();
            while (s.hasNext()) {
                sb.append(s.next());
            }
            str = sb.toString();
        }
        if (str == null || str.length() < 1) {
            return null;
        }
        if (type.isAssignableFrom(JsonNumber.class)) {
            if (str.contains(".")) {
                return type.cast(this.jsonProvider.createValue(Double.parseDouble(str)));
            }
            return type.cast(this.jsonProvider.createValue(Long.parseLong(str)));
        }
        if (type.isAssignableFrom(BigDecimal.class)) {
            return type.cast(new BigDecimal(str));
        }
        if (type.isAssignableFrom(BigInteger.class)) {
            return type.cast(new BigInteger(str));
        }
        if (type.isAssignableFrom(Double.class)) {
            return type.cast(Double.parseDouble(str));
        }
        if (type.isAssignableFrom(Integer.class)) {
            return type.cast(Integer.parseInt(str));
        }
        if (type.isAssignableFrom(Long.class)) {
            return type.cast(Long.parseLong(str));
        }
        if (type.isAssignableFrom(Float.class)) {
            return type.cast(Float.valueOf(Float.parseFloat(str)));
        }
        if (type.isAssignableFrom(Short.class)) {
            return type.cast(Short.parseShort(str));
        }
        throw new IOException("Unknown numeric type: " + type.getName());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS.providers.JsonPProvider", JsonPProvider.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
    }
}

