/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ServerStartedPhase2;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.cache.AuthCacheConfig;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.authentication.cache.CacheContext;
import com.ibm.ws.security.authentication.cache.CacheEvictionListener;
import com.ibm.ws.security.authentication.cache.CacheKeyProvider;
import com.ibm.ws.security.authentication.cache.CacheObject;
import com.ibm.ws.security.authentication.internal.cache.AuthCache;
import com.ibm.ws.security.authentication.internal.cache.AuthCacheConfigImpl;
import com.ibm.ws.security.authentication.internal.cache.InMemoryAuthCache;
import com.ibm.ws.security.authentication.internal.cache.JCacheAuthCache;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.ws.security.notifications.SecurityChangeListener;
import com.ibm.ws.security.registry.UserRegistryChangeListener;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import io.openliberty.jcache.CacheService;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthCacheServiceImpl
implements AuthCacheService,
UserRegistryChangeListener,
SecurityChangeListener {
    protected static final String KEY_CREDENTIAL_SERVICE = "credentialService";
    private static final TraceComponent tc = Tr.register(AuthCacheServiceImpl.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    private AuthCache cache;
    private final Set<CacheKeyProvider> cacheKeyProviders = new HashSet<CacheKeyProvider>();
    private boolean allowBasicAuthLookup = true;
    private int initialSize = 50;
    private int maxSize = 25000;
    private long timeoutInMilliSeconds = 600000L;
    private AuthCacheConfig authCacheConfig;
    private final Set<CacheEvictionListener> cacheEvictionListenerSet = new HashSet<CacheEvictionListener>();
    private final AtomicServiceReference<CredentialsService> credServiceRef = new AtomicServiceReference("credentialService");
    private CacheService cacheService = null;
    private boolean isServerStarted = false;
    private boolean autoClearCache = false;
    static final long serialVersionUID = 8117188397789444694L;

    @FFDCIgnore(value={Exception.class})
    public void insert(Subject subject, String userid, @Sensitive String password) {
        block2: {
            try {
                CacheObject cacheObject = new CacheObject(subject);
                CacheContext cacheContext = new CacheContext(this.authCacheConfig, cacheObject, userid, password);
                this.commonInsert(cacheContext, cacheObject);
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"There was a problem caching the subject.", (Object[])new Object[]{e});
            }
        }
    }

    @FFDCIgnore(value={Exception.class})
    public void insert(Subject subject, X509Certificate[] certChain) {
        block2: {
            try {
                CacheObject cacheObject = new CacheObject(subject);
                CacheContext cacheContext = new CacheContext(this.authCacheConfig, cacheObject, certChain);
                this.commonInsert(cacheContext, cacheObject);
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"There was a problem caching the subject.", (Object[])new Object[]{e});
            }
        }
    }

    @FFDCIgnore(value={Exception.class})
    public void insert(Subject subject) {
        block2: {
            try {
                CacheObject cacheObject = new CacheObject(subject);
                CacheContext cacheContext = new CacheContext(this.authCacheConfig, cacheObject);
                this.commonInsert(cacheContext, cacheObject);
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"There was a problem caching the subject.", (Object[])new Object[]{e});
            }
        }
    }

    private void commonInsert(CacheContext cacheContext, CacheObject cacheObject) throws Exception {
        for (CacheKeyProvider provider : this.cacheKeyProviders) {
            Object cacheKey = provider.provideKey(cacheContext);
            if (cacheKey instanceof Set) {
                for (Object key : (Set)cacheKey) {
                    this.addCacheObject(key, cacheObject);
                }
                continue;
            }
            if (cacheKey == null) continue;
            this.addCacheObject(cacheKey, cacheObject);
        }
    }

    private void addCacheObject(Object key, CacheObject cacheObject) {
        cacheObject.addLookupKey(key);
        this.cache.insert(key, cacheObject);
    }

    public Subject getSubject(Object cacheKey) {
        Subject subject = null;
        if (cacheKey != null) {
            CacheObject cacheObject = this.getCachedObject(cacheKey);
            subject = cacheObject != null ? cacheObject.getSubject() : null;
            subject = this.optionallyRemoveEntryForInvalidSubject(cacheObject, subject);
        }
        return subject;
    }

    private Subject optionallyRemoveEntryForInvalidSubject(CacheObject cacheObject, Subject subject) {
        CredentialsService credService;
        if (subject != null && (credService = (CredentialsService)this.credServiceRef.getService()) != null && !credService.isSubjectValid(subject)) {
            this.removeCachedObject(cacheObject);
            subject = null;
        }
        return subject;
    }

    public void remove(Object cacheKey) {
        CacheObject cacheObject;
        if (cacheKey != null && (cacheObject = this.getCachedObject(cacheKey)) != null) {
            this.removeCachedObject(cacheObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCachedObject(CacheObject cacheObject) {
        List lookupKeys;
        List list = lookupKeys = cacheObject.getLookupKeys();
        synchronized (list) {
            for (Object lookupKey : lookupKeys) {
                this.cache.remove(lookupKey);
            }
        }
    }

    public void removeAllEntries() {
        this.removeAllEntries(false);
    }

    public void removeAllEntries(boolean force) {
        this.cache.clearAllEntries(force);
    }

    protected CacheObject getCachedObject(Object cacheKey) {
        if (cacheKey instanceof byte[]) {
            cacheKey = new ByteArray((byte[])cacheKey);
        }
        return (CacheObject)this.cache.get(cacheKey);
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> newProperties) {
        this.credServiceRef.activate(componentContext);
        this.modified(newProperties);
    }

    protected void modified(Map<String, Object> newProperties) {
        this.initialSize = (Integer)newProperties.get("initialSize");
        this.maxSize = (Integer)newProperties.get("maxSize");
        this.timeoutInMilliSeconds = (Long)newProperties.get("timeout");
        this.allowBasicAuthLookup = (Boolean)newProperties.get("allowBasicAuthLookup");
        this.autoClearCache = (Boolean)newProperties.get("autoClearCache");
        if (this.initialSize > this.maxSize) {
            this.initialSize = this.maxSize;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The initial size of cache is greater than the maximum size, so resetting the initial size to maximum size " + this.initialSize), (Object[])new Object[0]);
            }
        }
        this.authCacheConfig = new AuthCacheConfigImpl(this.initialSize, this.maxSize, this.timeoutInMilliSeconds, this.allowBasicAuthLookup);
        this.stopCacheEvictionTask();
        InMemoryAuthCache inMemoryCache = new InMemoryAuthCache(this.initialSize, this.maxSize, this.timeoutInMilliSeconds, this.cacheEvictionListenerSet);
        this.cache = this.cacheService != null ? new JCacheAuthCache(this.cacheService, inMemoryCache, this) : inMemoryCache;
    }

    protected void deactivate(ComponentContext componentContext) {
        this.stopCacheEvictionTask();
        this.credServiceRef.deactivate(componentContext);
    }

    private void stopCacheEvictionTask() {
        if (this.cache != null) {
            this.cache.stopEvictionTask();
        }
    }

    protected void setCacheKeyProvider(CacheKeyProvider provider) {
        this.cacheKeyProviders.add(provider);
    }

    protected void unsetCacheKeyProvider(CacheKeyProvider provider) {
        this.cacheKeyProviders.remove(provider);
    }

    protected void setCacheEvictionListener(CacheEvictionListener cacheEvictionListener) {
        this.cacheEvictionListenerSet.add(cacheEvictionListener);
    }

    protected void unsetCacheEvictionListener(CacheEvictionListener cacheEvictionListener) {
        this.cacheEvictionListenerSet.remove(cacheEvictionListener);
    }

    protected void setCredentialService(ServiceReference<CredentialsService> reference) {
        this.credServiceRef.setReference(reference);
    }

    protected void unsetCredentialService(ServiceReference<CredentialsService> reference) {
        this.credServiceRef.unsetReference(reference);
    }

    protected void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    protected void unsetCacheService(CacheService cacheService) {
        this.cacheService = null;
    }

    public void notifyOfUserRegistryChange() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Clearing auth cache as UserRegistry configuration has changed.", (Object[])new Object[0]);
        }
        this.removeAllEntries();
    }

    public void notifyChange() {
        this.removeAllEntries();
    }

    protected synchronized void setServerStartedPhase2(ServerStartedPhase2 serverStartedPhase2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)": Server is started.", (Object[])new Object[0]);
        }
        this.isServerStarted = true;
    }

    @Trivial
    protected void unsetServerStartedPhase2(ServerStartedPhase2 serverStartedPhase2) {
        this.isServerStarted = false;
    }

    public boolean isServerStarted() {
        return this.isServerStarted;
    }

    public boolean getAutoClearCache() {
        return this.autoClearCache;
    }
}

