/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils.comms;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.List;
import java.util.StringTokenizer;

public class ProviderEndPoint {
    private static final TraceComponent tc = SibTr.register(ProviderEndPoint.class, "SIBUtils", "com.ibm.ws.sib.utils.CWSIUMessages");
    public static final String TARGET_TRANSPORT_CHAIN_BASIC = "InboundBasicMessaging";
    public static final String TARGET_TRANSPORT_CHAIN_SECURE = "InboundSecureMessaging";
    public static final String BOOTSTRAP_TRANSPORT_CHAIN_BASIC = "BootstrapBasicMessaging";
    public static final String BOOTSTRAP_TRANSPORT_CHAIN_SECURE = "BootstrapSecureMessaging";
    public static final String BOOTSTRAP_TRANSPORT_CHAIN_TUNNELED = "BootstrapTunneledMessaging";
    public static final String BOOTSTRAP_TRANSPORT_CHAIN_TUNNELED_SECURE = "BootstrapTunneledSecureMessaging";
    public static final String PROVIDER_ENDPOINTS = "providerEndpoints";
    public static final String PROVIDER_ENDPOINTS_LOCALHOST = "localhost";
    public static final String PROVIDER_ENDPOINTS_PORT_BASIC = "7276";
    public static final String PROVIDER_ENDPOINTS_PORT_SECURE = "7286";
    private static final String[][] SYNONYMS = new String[][]{{"BootstrapBasicMessaging", "InboundBasicMessaging", "BasicMessaging"}, {"BootstrapSecureMessaging", "InboundSecureMessaging", "SecureMessaging"}, {"BootstrapTunneledMessaging"}, {"BootstrapTunneledSecureMessaging"}};
    private String hostname;
    private Integer portNumber;
    private String chainName;

    public ProviderEndPoint(String host, Integer port) {
        this.hostname = host;
        this.portNumber = port;
    }

    public ProviderEndPoint(String host, Integer port, String chain) {
        this.hostname = host;
        this.portNumber = port;
        this.chainName = chain;
    }

    public String getHost() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.portNumber;
    }

    public String getChain() {
        return this.chainName;
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (other == this) {
            equal = true;
        } else if (other != null && other instanceof ProviderEndPoint) {
            ProviderEndPoint otherEndpoint = (ProviderEndPoint)other;
            boolean hostnamesEqual = this.hostname == null ? otherEndpoint.hostname == null : this.hostname.equals(otherEndpoint.hostname);
            boolean portNumbersEqual = this.portNumber == null ? otherEndpoint.portNumber == null : this.portNumber.equals(otherEndpoint.portNumber);
            boolean chainNamesEqual = this.chainName == null ? otherEndpoint.chainName == null : this.chainName.equals(otherEndpoint.chainName);
            equal = hostnamesEqual && portNumbersEqual && chainNamesEqual;
        }
        return equal;
    }

    public int hashCode() {
        int hostnameHash = this.hostname == null ? 12345 : this.hostname.hashCode();
        int portNumberHash = this.portNumber == null ? 54321 : this.portNumber.hashCode();
        int chainNameHash = this.chainName == null ? 12543 : this.chainName.hashCode();
        return hostnameHash ^ portNumberHash ^ chainNameHash;
    }

    public String toString() {
        return "EndPoint@" + Integer.toHexString(System.identityHashCode(this)) + ":- " + this.getEndPointInfo();
    }

    public String getEndPointInfo() {
        String hostString = "";
        hostString = this.hostname != null ? (this.hostname.indexOf(":") != -1 ? hostString + "[" + this.hostname + "]" : hostString + this.hostname) : hostString + this.hostname;
        hostString = this.chainName == null ? hostString + ":" + this.portNumber : hostString + ":" + this.portNumber + ":" + this.chainName;
        return hostString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean parseProviderEndpoints(String providerEndpoints, List<ProviderEndPoint> listOfEndPoints, boolean whenDefaultingUseSecurePort) throws IncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry(tc, "parseProviderEndpoints", new Object[]{providerEndpoints, listOfEndPoints, whenDefaultingUseSecurePort});
        }
        boolean hasUserDefinedEndPoints = false;
        if (providerEndpoints != null && providerEndpoints.trim().equals("")) {
            providerEndpoints = null;
        }
        if (providerEndpoints != null) {
            StringTokenizer st = new StringTokenizer(providerEndpoints, ",");
            while (st.hasMoreElements()) {
                ProviderEndPoint newEP;
                String host = null;
                String port = null;
                String chain = null;
                String str = st.nextToken();
                if (str == null) continue;
                hasUserDefinedEndPoints = true;
                int openBracePos = 0;
                openBracePos = str.indexOf("[");
                if (openBracePos != -1) {
                    int closeBracePos = 0;
                    closeBracePos = str.indexOf("]");
                    if (closeBracePos == -1) throw new IncorrectCallException(str);
                    host = str.substring(openBracePos + 1, closeBracePos);
                    str = str.substring(closeBracePos + 1);
                } else if (str.indexOf("]") != -1) {
                    throw new IncorrectCallException(str);
                }
                if (str.indexOf(" ") != -1) {
                    str = str.replaceAll(" ", "");
                }
                StringTokenizer st2 = new StringTokenizer(str, ":", true);
                int elementSearch = 1;
                while (st2.hasMoreTokens()) {
                    String next = st2.nextToken();
                    if (":".equals(next)) {
                        ++elementSearch;
                        continue;
                    }
                    switch (elementSearch) {
                        case 1: {
                            host = next;
                            break;
                        }
                        case 2: {
                            port = next;
                            break;
                        }
                        case 3: {
                            chain = ProviderEndPoint.resolveSynonymousChainName(next);
                            break;
                        }
                    }
                }
                if (host == null || host.trim().equals("")) {
                    host = PROVIDER_ENDPOINTS_LOCALHOST;
                }
                boolean usingDefaultPort = false;
                if (port == null || port.trim().equals("")) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug(tc, "No port was specified");
                    }
                    if (chain != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug(tc, "A non-empty chain was specified");
                        }
                        if (BOOTSTRAP_TRANSPORT_CHAIN_BASIC.equals(chain)) {
                            whenDefaultingUseSecurePort = false;
                        } else if (BOOTSTRAP_TRANSPORT_CHAIN_SECURE.equals(chain)) {
                            whenDefaultingUseSecurePort = true;
                        }
                    }
                    if (whenDefaultingUseSecurePort) {
                        port = PROVIDER_ENDPOINTS_PORT_SECURE;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Password specified so defaulting to " + port);
                        }
                    } else {
                        port = PROVIDER_ENDPOINTS_PORT_BASIC;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug(tc, "No password specified so defaulting to " + port);
                        }
                    }
                    usingDefaultPort = true;
                }
                if (chain == null || chain.trim().equals("")) {
                    chain = BOOTSTRAP_TRANSPORT_CHAIN_BASIC;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug(tc, "No chain specified so defaulting to " + chain);
                    }
                }
                if (listOfEndPoints.contains(newEP = new ProviderEndPoint(host, new Integer(port), chain))) continue;
                listOfEndPoints.add(newEP);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug(tc, listOfEndPoints.toString());
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) return hasUserDefinedEndPoints;
        SibTr.exit(tc, "parseProviderEndpoints", hasUserDefinedEndPoints);
        return hasUserDefinedEndPoints;
    }

    private static String resolveSynonymousChainName(String original) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry(tc, "resolveSynonymousChainName", (Object)original);
        }
        String actual = original;
        for (int i = 0; i < SYNONYMS.length; ++i) {
            for (int j = 0; j < SYNONYMS[i].length; ++j) {
                if (!SYNONYMS[i][j].equalsIgnoreCase(original)) continue;
                actual = SYNONYMS[i][0];
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit(tc, "resolveSynonymousChainName", (Object)actual);
        }
        return actual;
    }

    public static class IncorrectCallException
    extends Exception {
        private static final long serialVersionUID = 4554836035251059637L;
        private final String _badString;

        public IncorrectCallException(String bad) {
            this._badString = bad;
        }

        public String[] getInserts() {
            return new String[]{this._badString, ProviderEndPoint.PROVIDER_ENDPOINTS, "[<IPv6 address>]:<port>:<chain>"};
        }
    }
}

