/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure.internal;

import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public final class NamedSpiManager<T> {
    private final Map<String, Supplier<T>> nameToProvider;
    private final ConcurrentMap<String, Optional<T>> nameToImplementation = new ConcurrentHashMap<String, Optional<T>>();

    private NamedSpiManager(Map<String, Supplier<T>> nameToProvider) {
        this.nameToProvider = nameToProvider;
    }

    static <T> NamedSpiManager<T> create(Map<String, Supplier<T>> nameToProvider) {
        return new NamedSpiManager<T>(nameToProvider);
    }

    public static <T> NamedSpiManager<T> createEmpty() {
        return NamedSpiManager.create(Collections.emptyMap());
    }

    @Nullable
    public T getByName(String name) {
        return this.nameToImplementation.computeIfAbsent(name, this::tryLoadImplementationForName).orElse(null);
    }

    private Optional<T> tryLoadImplementationForName(String name) {
        Supplier<T> provider = this.nameToProvider.get(name);
        if (provider == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(provider.get());
    }
}

