/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.io.async.IAbstractAsyncFuture;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.io.async.ICompletionListener;
import com.ibm.io.async.TimerWorkItem;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcpchannel.internal.AioSocketIOChannel;
import com.ibm.ws.tcpchannel.internal.AioTCPReadRequestContextImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;
import java.net.SocketTimeoutException;

class AioReadCompletionListener
implements ICompletionListener {
    private static final TraceComponent tc = Tr.register(AioReadCompletionListener.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private static volatile IOException connClosedException = null;

    AioReadCompletionListener() {
    }

    @Override
    public void futureCompleted(IAbstractAsyncFuture future, Object o) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"AioReadCompletionListener.futureCompleted", (Object[])new Object[0]);
        }
        AioTCPReadRequestContextImpl req = (AioTCPReadRequestContextImpl)o;
        boolean errorOccurred = false;
        IOException ioe = null;
        long byteCount = 0L;
        boolean complete = false;
        VirtualConnection vci = null;
        TimerWorkItem twi = future.getTimeoutWorkItem();
        if (twi != null) {
            twi.state = 2L;
        }
        if ((vci = req.getTCPConnLink().getVirtualConnection()) != null) {
            if (vci.isInputStateTrackingOperational() && !vci.requestPermissionToFinishRead()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Can't get permission to finish read, throwing read request away.", (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"AioReadCompletionListener.futureCompleted");
                }
                return;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Can't get virtual connection object, throwing read request away.", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"AioReadCompletionListener.futureCompleted");
            }
            return;
        }
        try {
            IAsyncFuture fut = (IAsyncFuture)future;
            byteCount = fut.getByteCount();
            if (fut.getJITBuffer() != null) {
                req.setBuffer(fut.getJITBuffer());
            }
            if (byteCount == 0L) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getByteCount returned 0, channel must be closed ", (Object[])new Object[0]);
                }
                errorOccurred = true;
                if (connClosedException == null) {
                    connClosedException = new IOException("Read failed: Connection closed by peer.");
                }
                ioe = connClosedException;
            } else {
                req.postProcessReadBuffers(byteCount);
                complete = req.updateIOCounts(byteCount, 0);
            }
        }
        catch (AsyncTimeoutException ate) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("exception caught: " + ate), (Object[])new Object[0]);
            }
            ioe = new SocketTimeoutException(ate.getMessage());
            ioe.initCause(ate);
            errorOccurred = true;
        }
        catch (IOException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("exception caught: " + ex), (Object[])new Object[0]);
            }
            ioe = ex;
            errorOccurred = true;
        }
        catch (InterruptedException ie) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("AioReadCompletionListener caught exception. " + ie), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)ie, (String)(this.getClass().getName() + ".futureCompleted"), (String)"134");
        }
        if (!errorOccurred) {
            if (complete) {
                future.setFullyCompleted(true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"calling callback.complete method", (Object[])new Object[0]);
                }
                req.getReadCompletedCallback().complete(req.getTCPConnLink().getVirtualConnection(), req);
            } else {
                long remainingTimeout;
                if (req.getTCPConnLink().getConfig().getDumpStatsInterval() > 0) {
                    req.getTCPConnLink().getTCPChannel().totalPartialAsyncReads.incrementAndGet();
                }
                if ((remainingTimeout = (long)req.getTimeoutInterval()) != 0L && (remainingTimeout = req.getTimeoutTime() - System.currentTimeMillis()) <= 0L) {
                    ioe = new SocketTimeoutException("Async read timed out after reading partial data");
                    errorOccurred = true;
                }
                if (!errorOccurred) {
                    try {
                        ((AioSocketIOChannel)req.getTCPConnLink().getSocketIOChannel()).readAIO(req, true, remainingTimeout);
                    }
                    catch (IOException ex) {
                        ioe = ex;
                        errorOccurred = true;
                    }
                }
            }
        }
        if (errorOccurred) {
            if (req.getJITAllocateAction() && req.getBuffer() != null) {
                req.getBuffer().release();
                req.setBuffer(null);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while doing IO requested on local: " + req.getTCPConnLink().getSocketIOChannel().getSocket().getLocalSocketAddress() + " remote: " + req.getTCPConnLink().getSocketIOChannel().getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("Calling read error callback with Exception is: " + ioe), (Object[])new Object[0]);
            }
            req.getReadCompletedCallback().error(req.getTCPConnLink().getVirtualConnection(), req, ioe);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AioReadCompletionListener.futureCompleted");
        }
    }
}

