/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelUtils;
import com.ibm.websphere.event.Event;
import com.ibm.websphere.event.EventHandler;
import com.ibm.websphere.event.Topic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import org.osgi.service.component.ComponentContext;

public class CHFWEventHandler
implements EventHandler {
    private static final TraceComponent tc = Tr.register(CHFWEventHandler.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    public static final Topic EVENT_CHECK_MISSING = new Topic("com/ibm/websphere/channelfw/CHECK_MISSING");

    protected void activate(ComponentContext context) {
    }

    protected void deactivate(ComponentContext context) {
    }

    public void handleEvent(Event event) {
        String topic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Handle event; event=" + event.getTopic()), (Object[])new Object[0]);
        }
        if ((topic = event.getTopic()).equalsIgnoreCase(ChannelFramework.EVENT_STOPCHAIN.getName())) {
            String chainName = (String)event.getProperty("ChainName", String.class);
            if (null != chainName) {
                this.stopChain(chainName, event);
            } else {
                String channelName = (String)event.getProperty("ChannelName", String.class);
                if (null != channelName) {
                    this.stopChannel(channelName, event);
                }
            }
        } else if (topic.equalsIgnoreCase(EVENT_CHECK_MISSING.getName())) {
            ChannelUtils.checkMissingConfig();
        }
    }

    private void stopChain(String name, Event event) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Stop chain event; chain=" + name), (Object[])new Object[0]);
            }
            ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
            try {
                if (cf.isChainRunning(name)) {
                    cf.stopChain(name, 0L);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"stopChain", (Object[])new Object[]{event, cf});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)("Error stopping chain; " + e), (Object[])new Object[0]);
            }
        }
    }

    private void stopChannel(String name, Event event) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Stop chain event; channel=" + name), (Object[])new Object[0]);
            }
            ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
            try {
                ChainData[] chains;
                for (ChainData chain : chains = cf.getAllChains(name)) {
                    if (!cf.isChainRunning(chain)) continue;
                    cf.stopChain(chain, 0L);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"stopChannel", (Object[])new Object[]{event, cf});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)("Error stopping chain; " + e), (Object[])new Object[0]);
            }
        }
    }
}

