/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;

public class CachedSessionProperties {
    private static TraceComponent tc = SibTr.register(CachedSessionProperties.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private SIDestinationAddress destinationAddress = null;
    private SelectionCriteria criteria = null;
    private Reliability unrecovReliability = null;

    public CachedSessionProperties(SIDestinationAddress destAddr, SelectionCriteria sc, Reliability rel) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.destinationAddress = destAddr;
        this.criteria = sc;
        this.unrecovReliability = rel;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public boolean equals(CachedSessionProperties other) {
        boolean result;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"equals");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Params: other", (Object)other);
        }
        boolean bl = result = this.areTheyTheSame(this.destinationAddress, other.getDestinationAddress()) && this.areTheyTheSame(this.criteria, other.getSelectionCriteria()) && this.areTheyTheSame(this.unrecovReliability, other.getReliability());
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"rc=", (Object)("" + result));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"equals");
        }
        return result;
    }

    private boolean areTheyTheSame(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof String) {
            return ((String)obj1).equals(obj2);
        }
        if (obj1 instanceof Reliability) {
            return ((Reliability)obj1).compareTo(obj2) == 0;
        }
        if (obj1 instanceof SIDestinationAddress) {
            return obj1.toString().equals(obj2.toString());
        }
        return false;
    }

    public String toString() {
        return "Destination Addr: '" + this.destinationAddress + "', SelectionCriteria: '" + this.criteria + "' , Reliability: " + this.unrecovReliability;
    }

    public SIDestinationAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public SelectionCriteria getSelectionCriteria() {
        return this.criteria;
    }

    public Reliability getReliability() {
        return this.unrecovReliability;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CachedSessionProperties.java, SIB.comms, WASX.SIB, aa1225.01 1.10");
        }
    }
}

